/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import io.confluent.csid.utils.LoopingResumingIterator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LoopingResumingIteratorTest {
    LoopingResumingIteratorTest() {
    }

    @Test
    void noFrom() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(0, "a");
        map.put(1, "b");
        map.put(2, "c");
        map.put(3, "d");
        LoopingResumingIterator iterator = new LoopingResumingIterator(map);
        ArrayList<Map.Entry> results = new ArrayList<Map.Entry>();
        Optional x = iterator.next();
        while (x.isPresent()) {
            results.add((Map.Entry)x.get());
            x = iterator.next();
        }
        Assertions.assertThat(results).extracting(Map.Entry::getKey).containsExactly((Object[])new Integer[]{0, 1, 2, 3});
    }

    @Test
    public void fromInMiddle() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(0, "a");
        map.put(1, "b");
        map.put(2, "c");
        map.put(3, "d");
        LoopingResumingIterator iterator = LoopingResumingIterator.build((Object)2, map);
        ArrayList<Map.Entry> results = new ArrayList<Map.Entry>();
        Optional x = iterator.next();
        while (x.isPresent()) {
            results.add((Map.Entry)x.get());
            x = iterator.next();
        }
        Assertions.assertThat(results).extracting(Map.Entry::getKey).containsExactly((Object[])new Integer[]{2, 3, 0, 1});
    }

    @Test
    void fromIsEnd() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(0, "a");
        map.put(1, "b");
        map.put(2, "c");
        map.put(3, "d");
        LoopingResumingIterator iterator = LoopingResumingIterator.build((Object)3, map);
        ArrayList<Map.Entry> results = new ArrayList<Map.Entry>();
        Optional x = iterator.next();
        while (x.isPresent()) {
            results.add((Map.Entry)x.get());
            x = iterator.next();
        }
        Assertions.assertThat(results).extracting(Map.Entry::getKey).containsExactly((Object[])new Integer[]{3, 0, 1, 2});
    }

    @Test
    public void fromBeginningFirstElement() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(0, "a");
        map.put(1, "b");
        map.put(2, "c");
        map.put(3, "d");
        LoopingResumingIterator iterator = LoopingResumingIterator.build((Object)0, map);
        ArrayList<Map.Entry> results = new ArrayList<Map.Entry>();
        Optional x = iterator.next();
        while (x.isPresent()) {
            results.add((Map.Entry)x.get());
            x = iterator.next();
        }
        Assertions.assertThat(results).extracting(Map.Entry::getKey).containsExactly((Object[])new Integer[]{0, 1, 2, 3});
    }

    @Test
    void fromDoesntExist() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(0, "a");
        map.put(1, "b");
        map.put(2, "c");
        map.put(3, "d");
        LoopingResumingIterator iterator = LoopingResumingIterator.build((Object)88, map);
        ArrayList<Map.Entry> results = new ArrayList<Map.Entry>();
        Optional x = iterator.next();
        while (x.isPresent()) {
            results.add((Map.Entry)x.get());
            x = iterator.next();
        }
        Assertions.assertThat(results).extracting(Map.Entry::getKey).containsExactly((Object[])new Integer[]{0, 1, 2, 3});
    }

    @Test
    void loopsCorrectly() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(0, "a");
        map.put(1, "b");
        map.put(2, "c");
        LoopingResumingIterator entries = LoopingResumingIterator.build(null, map);
        ArrayList<Map.Entry> results = new ArrayList<Map.Entry>();
        LoopingResumingIterator iterator = entries;
        Optional x = iterator.next();
        while (x.isPresent()) {
            results.add((Map.Entry)x.get());
            x = iterator.next();
        }
        Assertions.assertThat(results).extracting(Map.Entry::getKey).containsExactly((Object[])new Integer[]{0, 1, 2});
        entries = LoopingResumingIterator.build((Object)2, map);
        results = new ArrayList();
        iterator = entries;
        x = iterator.next();
        while (x.isPresent()) {
            results.add((Map.Entry)x.get());
            x = iterator.next();
        }
        Assertions.assertThat(results).extracting(Map.Entry::getKey).containsExactly((Object[])new Integer[]{2, 0, 1});
        Truth8.assertThat((Optional)entries.next()).isEmpty();
    }

    @Test
    void loopsCorrectlyWithStartingObjectIndexZero() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(0, "a");
        map.put(1, "b");
        map.put(2, "c");
        LoopingResumingIterator entries = LoopingResumingIterator.build((Object)0, map);
        ArrayList<Map.Entry> results = new ArrayList<Map.Entry>();
        LoopingResumingIterator iterator = entries;
        Optional x = iterator.next();
        while (x.isPresent()) {
            results.add((Map.Entry)x.get());
            x = iterator.next();
        }
        Assertions.assertThat(results).extracting(Map.Entry::getKey).containsExactly((Object[])new Integer[]{0, 1, 2});
        Truth8.assertThat((Optional)entries.next()).isEmpty();
    }

    @Test
    void emptyInitialStartingKey() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(0, "a");
        map.put(1, "b");
        LoopingResumingIterator iterator = LoopingResumingIterator.build(null, map);
        Map.Entry next = (Map.Entry)iterator.next().get();
        Truth.assertThat((Integer)((Integer)next.getKey())).isEqualTo((Object)0);
        Truth.assertThat((String)((String)next.getValue())).isEqualTo((Object)"a");
    }

    @Test
    void demoOfNoSuchElementIssue() {
        int INDEX_TO_REMOVE = 4;
        ConcurrentHashMap<Integer, String> map = new ConcurrentHashMap<Integer, String>();
        map.put(0, "a");
        map.put(1, "b");
        map.put(2, "c");
        map.put(3, "d");
        map.put(4, "e");
        map.put(5, "f");
        map.put(6, "g");
        map.put(7, "h");
        map.put(8, "i");
        map.put(9, "j");
        ArrayList<Optional> results = new ArrayList<Optional>();
        LoopingResumingIterator iterator = LoopingResumingIterator.build((Object)4, map);
        Optional x = iterator.next();
        while (x.isPresent()) {
            results.add(x);
            if ((Integer)((Map.Entry)x.get()).getKey() == 4) {
                map.remove(4);
            }
            x = iterator.next();
        }
        LinkedHashMap<Integer, String> expected = new LinkedHashMap<Integer, String>();
        expected.put(4, "e");
        expected.put(5, "f");
        expected.put(6, "g");
        expected.put(7, "h");
        expected.put(8, "i");
        expected.put(9, "j");
        expected.put(0, "a");
        expected.put(1, "b");
        expected.put(2, "c");
        expected.put(3, "d");
        List expectedAsList = expected.entrySet().stream().map(Optional::of).collect(Collectors.toList());
        Truth.assertThat(results).containsExactlyElementsIn(expectedAsList).inOrder();
        Truth8.assertThat((Optional)iterator.next()).isEmpty();
        map.clear();
        Truth8.assertThat((Optional)iterator.next()).isEmpty();
    }
}

