/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import com.google.auto.service.AutoService;
import io.confluent.csid.utils.StringUtils;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

@AutoService(value={TestExecutionListener.class})
public class MyRunListener
implements TestExecutionListener {
    private final String template = "\n=========\n   JUNIT {}:    {} ({})\n=========";

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.log(StringUtils.msg((String)"\n=========\n   JUNIT {}:    {} ({})\n=========", (Object[])new Object[]{"Test plan execution started", testPlan, ""}));
    }

    private void log(String msg) {
        System.out.println(msg);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.log(StringUtils.msg((String)"\n=========\n   JUNIT {}:    {} ({})\n=========", (Object[])new Object[]{"skipped", testIdentifier.getDisplayName(), reason}));
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.log(StringUtils.msg((String)"\n=========\n   JUNIT {}:    {} ({})\n=========", (Object[])new Object[]{"started", testIdentifier.getDisplayName(), testIdentifier.getLegacyReportingName()}));
    }
}

