/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import io.confluent.csid.utils.StringUtils;
import io.confluent.parallelconsumer.AbstractParallelEoSStreamProcessorTestBase;
import io.confluent.parallelconsumer.internal.InternalRuntimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.concurrent.atomic.AtomicInteger;

public class ProgressTracker {
    public static final int WARMED_UP_AFTER_X_MESSAGES = 50;
    private final AtomicInteger processedCount;
    private final AtomicInteger lastSeen = new AtomicInteger(0);
    private final AtomicInteger rounds = new AtomicInteger(0);
    private Duration timeout = AbstractParallelEoSStreamProcessorTestBase.defaultTimeout;
    private Integer roundsAllowed = 10;
    private final int coldRoundsAllowed = 20;
    private int highestRoundCountSeen = 0;
    private final Instant startTime = Instant.now();

    public ProgressTracker(AtomicInteger processedCount, Integer roundsAllowed, Duration timeout) {
        this.processedCount = processedCount;
        if (roundsAllowed != null && timeout != null) {
            throw new IllegalArgumentException("Can't provide both a timeout and a number of rounds");
        }
        this.roundsAllowed = roundsAllowed;
        this.timeout = timeout;
    }

    public ProgressTracker(AtomicInteger processedCount) {
        this.processedCount = processedCount;
    }

    public boolean hasProgressNotBeenMade() {
        boolean progress = this.processedCount.get() > this.lastSeen.get();
        boolean warmedUp = this.processedCount.get() > 50;
        boolean enoughAttempts = this.hasTimeoutPassed();
        if (warmedUp && !progress && enoughAttempts) {
            return true;
        }
        if (!warmedUp && this.roundsAllowed != null && this.rounds.get() > 20) {
            return true;
        }
        if (progress) {
            this.reset();
        }
        this.lastSeen.set(this.processedCount.get());
        this.rounds.incrementAndGet();
        return false;
    }

    private boolean hasTimeoutPassed() {
        if (this.roundsAllowed != null) {
            return this.rounds.get() > this.roundsAllowed;
        }
        Duration remainingTime = Duration.between(Instant.now(), this.getDeadline());
        return remainingTime.isNegative();
    }

    private Temporal getDeadline() {
        return this.startTime.plus(this.timeout);
    }

    private void reset() {
        if (this.rounds.get() > this.highestRoundCountSeen) {
            this.highestRoundCountSeen = this.rounds.get();
        }
        this.rounds.set(0);
    }

    public void checkForProgressExceptionally() throws Exception {
        boolean noProgress = this.hasProgressNotBeenMade();
        if (noProgress) {
            throw this.constructError();
        }
    }

    public Exception constructError() {
        return this.constructError("");
    }

    public Exception constructError(String messageToAppend) {
        return new InternalRuntimeException(StringUtils.msg((String)"No progress beyond {} records after {} rounds. {}", (Object[])new Object[]{this.processedCount, this.rounds, messageToAppend}));
    }

    public AtomicInteger getRounds() {
        return this.rounds;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public int getHighestRoundCountSeen() {
        return this.highestRoundCountSeen;
    }
}

