/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import java.lang.reflect.Method;
import org.junit.jupiter.api.DisplayNameGenerator;

public class ReplaceCamelCase
extends DisplayNameGenerator.Standard {
    public String generateDisplayNameForClass(Class<?> testClass) {
        return this.replaceCapitals(super.generateDisplayNameForClass(testClass));
    }

    public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
        return this.replaceCapitals(super.generateDisplayNameForNestedClass(nestedClass));
    }

    public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
        return super.generateDisplayNameForClass(testClass) + ": " + this.replaceCapitals(testMethod.getName());
    }

    private String replaceCapitals(String name) {
        name = name.replaceAll("([A-Z])", " $1");
        name = name.replaceAll("([0-9]+)", " $1");
        name = name.trim();
        name = this.capitiliseSentence(name);
        return name;
    }

    private String capitiliseSentence(String sentence) {
        String firstLetterUpper = (sentence.charAt(0) + "").toUpperCase();
        String withoutFirstLetter = sentence.substring(1).toLowerCase();
        return firstLetterUpper + withoutFirstLetter;
    }
}

