/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);

    public static void sleepQuietly(int ms) {
        log.debug("Sleeping for {}", (Object)ms);
        Thread.sleep(ms);
        log.debug("Woke up (slept for {})", (Object)ms);
    }

    public static void sleepLog(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.error("Sleep of {} interrupted", (Object)e, (Object)ms);
        }
    }

    public static void sleepQuietly(long ms) {
        ThreadUtils.sleepQuietly((int)ms);
    }

    public static void sleepSecondsLog(int seconds) {
        ThreadUtils.sleepLog(seconds * 1000);
    }
}

