/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.assertj.core.presentation.StandardRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrimListRepresentation
extends StandardRepresentation {
    private static final Logger log = LoggerFactory.getLogger(TrimListRepresentation.class);
    private final int sizeLimit = 10;
    protected static String msg = "Collection has been trimmed...";

    public String toStringOf(Object raw) {
        List aList;
        Object[] anObjectArray;
        Set aSet;
        if (raw instanceof Set && (aSet = (Set)((Object)raw)).size() > 10) {
            raw = new ArrayList(aSet);
        }
        if (raw instanceof Object[] && (anObjectArray = (Object[])raw).length > 10) {
            raw = Arrays.stream(anObjectArray).collect(Collectors.toList());
        }
        if (raw instanceof String[] && (anObjectArray = (String[])raw).length > 10) {
            raw = Arrays.stream(anObjectArray).collect(Collectors.toList());
        }
        if (raw instanceof List && (aList = (List)raw).size() > 10) {
            log.trace("List too long ({}), trimmed...", (Object)aList.size());
            List trimmedListView = aList.subList(0, 10);
            CopyOnWriteArrayList<String> copy = new CopyOnWriteArrayList<String>(trimmedListView);
            copy.add(msg);
            return super.toStringOf(copy);
        }
        return super.toStringOf(raw);
    }
}

