/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.csid.utils;

import io.confluent.csid.utils.TrimListRepresentation;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.presentation.Representation;
import org.junit.jupiter.api.Test;

class TrimListRepresentationTest {
    TrimListRepresentationTest() {
    }

    @Test
    void customRepresentationFail() {
        List one = IntStream.range(0, 1000).boxed().collect(Collectors.toList());
        List two = IntStream.range(999, 2000).boxed().collect(Collectors.toList());
        Assertions.assertThatThrownBy(() -> ((ListAssert)Assertions.assertThat((List)one).withRepresentation((Representation)new TrimListRepresentation())).containsAll((Iterable)two)).hasMessageContaining("trimmed");
    }

    @Test
    void customRepresentationPass() {
        Assertions.useRepresentation((Representation)new TrimListRepresentation());
        List one = IntStream.range(0, 1000).boxed().collect(Collectors.toList());
        List two = IntStream.range(0, 1000).boxed().collect(Collectors.toList());
        SoftAssertions all = new SoftAssertions();
        all.assertThat(one).containsAll(two);
        all.assertAll();
    }
}

