/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import io.confluent.csid.utils.KafkaTestUtils;
import io.confluent.parallelconsumer.BatchTestBase;
import io.confluent.parallelconsumer.BatchTestMethods;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.ParallelEoSStreamProcessorTestBase;
import io.confluent.parallelconsumer.PollContext;
import io.confluent.parallelconsumer.internal.AbstractParallelEoSStreamProcessor;
import io.confluent.parallelconsumer.internal.RateLimiter;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreBatchTest
extends ParallelEoSStreamProcessorTestBase
implements BatchTestBase {
    private static final Logger log = LoggerFactory.getLogger(CoreBatchTest.class);
    BatchTestMethods<Void> batchTestMethods;

    @BeforeEach
    void setup() {
        this.batchTestMethods = new BatchTestMethods<Void>((ParallelEoSStreamProcessorTestBase)this){

            @Override
            protected KafkaTestUtils getKtu() {
                return CoreBatchTest.this.ktu;
            }

            @Override
            protected Void averageBatchSizeTestPollStep(PollContext<String, String> recordList) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                return null;
            }

            @Override
            protected void averageBatchSizeTestPoll(AtomicInteger numBatches, AtomicInteger numRecords, RateLimiter statusLogger) {
                CoreBatchTest.this.parallelConsumer.poll(pollBatch -> this.averageBatchSizeTestPollInner(numBatches, numRecords, statusLogger, (PollContext<String, String>)pollBatch));
            }

            @Override
            protected AbstractParallelEoSStreamProcessor getPC() {
                return CoreBatchTest.this.parallelConsumer;
            }

            @Override
            public void simpleBatchTestPoll(List<PollContext<String, String>> batchesReceived) {
                CoreBatchTest.this.parallelConsumer.poll(context -> {
                    log.debug("Batch of messages: {}", (Object)context.getOffsetsFlattened());
                    batchesReceived.add((PollContext<String, String>)context);
                });
            }

            @Override
            protected void batchFailPoll(List<PollContext<String, String>> accumlativeReceivedBatches) {
                CoreBatchTest.this.parallelConsumer.poll(pollBatch -> {
                    log.debug("Batch of messages: {}", (Object)pollBatch.getOffsetsFlattened());
                    this.batchFailPollInner((PollContext<String, String>)pollBatch);
                    accumlativeReceivedBatches.add((PollContext<String, String>)pollBatch);
                });
            }
        };
    }

    @Override
    @Test
    public void averageBatchSizeTest() {
        this.batchTestMethods.averageBatchSizeTest(50000);
    }

    @Override
    @ParameterizedTest
    @EnumSource
    public void simpleBatchTest(ParallelConsumerOptions.ProcessingOrder order) {
        this.batchTestMethods.simpleBatchTest(order);
    }

    @Override
    @ParameterizedTest
    @EnumSource
    public void batchFailureTest(ParallelConsumerOptions.ProcessingOrder order) {
        this.batchTestMethods.batchFailureTest(order);
    }
}

