/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import com.google.common.truth.Truth;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.ParallelEoSStreamProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import pl.tlinkowski.unij.api.UniLists;

class MockConsumerTest {
    private static final Logger log = LoggerFactory.getLogger(MockConsumerTest.class);
    private final String topic = MockConsumerTest.class.getSimpleName();

    MockConsumerTest() {
    }

    @Test
    void mockConsumer() {
        MockConsumer mockConsumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
        HashMap<TopicPartition, Long> startOffsets = new HashMap<TopicPartition, Long>();
        TopicPartition tp = new TopicPartition(this.topic, 0);
        startOffsets.put(tp, 0L);
        ParallelConsumerOptions options = ParallelConsumerOptions.builder().consumer((Consumer)mockConsumer).build();
        ParallelEoSStreamProcessor parallelConsumer = new ParallelEoSStreamProcessor(options);
        parallelConsumer.subscribe((Collection)UniLists.of((Object)this.topic));
        mockConsumer.rebalance(Collections.singletonList(tp));
        parallelConsumer.onPartitionsAssigned((Collection)UniLists.of((Object)tp));
        mockConsumer.updateBeginningOffsets(startOffsets);
        this.addRecords((MockConsumer<String, String>)mockConsumer);
        ConcurrentLinkedQueue records = new ConcurrentLinkedQueue();
        parallelConsumer.poll(recordContexts -> recordContexts.forEach(recordContext -> {
            log.warn("Processing: {}", recordContext);
            records.add(recordContext);
        }));
        Awaitility.await().untilAsserted(() -> Truth.assertThat((Iterable)records).hasSize(3));
    }

    private void addRecords(MockConsumer<String, String> mockConsumer) {
        mockConsumer.addRecord(new ConsumerRecord(this.topic, 0, 0L, (Object)"key", (Object)"value"));
        mockConsumer.addRecord(new ConsumerRecord(this.topic, 0, 1L, (Object)"key", (Object)"value"));
        mockConsumer.addRecord(new ConsumerRecord(this.topic, 0, 2L, (Object)"key", (Object)"value"));
    }
}

