/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.Subject;
import io.confluent.parallelconsumer.CommitModeSubject;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.ProcessingOrderSubject;
import io.confluent.parallelconsumer.autoShaded.java.time.DurationSubject;
import io.confluent.parallelconsumer.autoShaded.java.util.function.FunctionSubject;
import io.confluent.parallelconsumer.truth.ConsumerSubject;
import io.stubbs.truth.generator.subjects.MyStringSubject;
import java.time.Duration;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerSubject;

public class ParallelConsumerOptionsParentSubject
extends Subject {
    protected final ParallelConsumerOptions actual;

    protected ParallelConsumerOptionsParentSubject(FailureMetadata failureMetadata, ParallelConsumerOptions actual) {
        super(failureMetadata, (Object)actual);
        this.actual = actual;
    }

    public IntegerSubject getBatchSize() {
        this.isNotNull();
        return this.check("getBatchSize()", new Object[0]).that(this.actual.getBatchSize());
    }

    public void hasBatchSizeNotEqualTo(Integer expected) {
        if (this.actual.getBatchSize().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected BatchSize NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasBatchSizeEqualTo(Integer expected) {
        if (!this.actual.getBatchSize().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected BatchSize to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public DurationSubject getCommitInterval() {
        this.isNotNull();
        return (DurationSubject)this.check("getCommitInterval()", new Object[0]).about(DurationSubject.durations()).that((Object)this.actual.getCommitInterval());
    }

    public void hasCommitIntervalNotEqualTo(Duration expected) {
        if (this.actual.getCommitInterval().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected CommitInterval NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasCommitIntervalEqualTo(Duration expected) {
        if (!this.actual.getCommitInterval().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected CommitInterval to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public DurationSubject getCommitLockAcquisitionTimeout() {
        this.isNotNull();
        return (DurationSubject)this.check("getCommitLockAcquisitionTimeout()", new Object[0]).about(DurationSubject.durations()).that((Object)this.actual.getCommitLockAcquisitionTimeout());
    }

    public void hasCommitLockAcquisitionTimeoutNotEqualTo(Duration expected) {
        if (this.actual.getCommitLockAcquisitionTimeout().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected CommitLockAcquisitionTimeout NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasCommitLockAcquisitionTimeoutEqualTo(Duration expected) {
        if (!this.actual.getCommitLockAcquisitionTimeout().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected CommitLockAcquisitionTimeout to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public CommitModeSubject getCommitMode() {
        this.isNotNull();
        return (CommitModeSubject)this.check("getCommitMode()", new Object[0]).about(CommitModeSubject.commitModes()).that((Object)this.actual.getCommitMode());
    }

    public void hasCommitModeNotEqualTo(ParallelConsumerOptions.CommitMode expected) {
        if (this.actual.getCommitMode().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected CommitMode NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasCommitModeEqualTo(ParallelConsumerOptions.CommitMode expected) {
        if (!this.actual.getCommitMode().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected CommitMode to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public ConsumerSubject getConsumer() {
        this.isNotNull();
        return (ConsumerSubject)this.check("getConsumer()", new Object[0]).about(ConsumerSubject.consumers()).that((Object)this.actual.getConsumer());
    }

    public void hasConsumerNotEqualTo(Consumer expected) {
        if (this.actual.getConsumer().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Consumer NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasConsumerEqualTo(Consumer expected) {
        if (!this.actual.getConsumer().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Consumer to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public DurationSubject getDefaultMessageRetryDelay() {
        this.isNotNull();
        return (DurationSubject)this.check("getDefaultMessageRetryDelay()", new Object[0]).about(DurationSubject.durations()).that((Object)this.actual.getDefaultMessageRetryDelay());
    }

    public void hasDefaultMessageRetryDelayNotEqualTo(Duration expected) {
        if (this.actual.getDefaultMessageRetryDelay().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected DefaultMessageRetryDelay NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasDefaultMessageRetryDelayEqualTo(Duration expected) {
        if (!this.actual.getDefaultMessageRetryDelay().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected DefaultMessageRetryDelay to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public MyStringSubject getManagedExecutorService() {
        this.isNotNull();
        return (MyStringSubject)this.check("getManagedExecutorService()", new Object[0]).about(MyStringSubject.strings()).that((Object)this.actual.getManagedExecutorService());
    }

    public void hasManagedExecutorServiceNotEqualTo(String expected) {
        if (this.actual.getManagedExecutorService().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ManagedExecutorService NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasManagedExecutorServiceEqualTo(String expected) {
        if (!this.actual.getManagedExecutorService().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ManagedExecutorService to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public MyStringSubject getManagedThreadFactory() {
        this.isNotNull();
        return (MyStringSubject)this.check("getManagedThreadFactory()", new Object[0]).about(MyStringSubject.strings()).that((Object)this.actual.getManagedThreadFactory());
    }

    public void hasManagedThreadFactoryNotEqualTo(String expected) {
        if (this.actual.getManagedThreadFactory().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ManagedThreadFactory NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasManagedThreadFactoryEqualTo(String expected) {
        if (!this.actual.getManagedThreadFactory().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ManagedThreadFactory to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IntegerSubject getMaxConcurrency() {
        this.isNotNull();
        return this.check("getMaxConcurrency()", new Object[0]).that(Integer.valueOf(this.actual.getMaxConcurrency()));
    }

    public void hasMaxConcurrencyNotEqualTo(int expected) {
        if (this.actual.getMaxConcurrency() == expected) {
            this.failWithActual(Fact.fact((String)"expected MaxConcurrency NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasMaxConcurrencyEqualTo(int expected) {
        if (this.actual.getMaxConcurrency() != expected) {
            this.failWithActual(Fact.fact((String)"expected MaxConcurrency to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IntegerSubject getMaxFailureHistory() {
        this.isNotNull();
        return this.check("getMaxFailureHistory()", new Object[0]).that(Integer.valueOf(this.actual.getMaxFailureHistory()));
    }

    public void hasMaxFailureHistoryNotEqualTo(int expected) {
        if (this.actual.getMaxFailureHistory() == expected) {
            this.failWithActual(Fact.fact((String)"expected MaxFailureHistory NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasMaxFailureHistoryEqualTo(int expected) {
        if (this.actual.getMaxFailureHistory() != expected) {
            this.failWithActual(Fact.fact((String)"expected MaxFailureHistory to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public DurationSubject getOffsetCommitTimeout() {
        this.isNotNull();
        return (DurationSubject)this.check("getOffsetCommitTimeout()", new Object[0]).about(DurationSubject.durations()).that((Object)this.actual.getOffsetCommitTimeout());
    }

    public void hasOffsetCommitTimeoutNotEqualTo(Duration expected) {
        if (this.actual.getOffsetCommitTimeout().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected OffsetCommitTimeout NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasOffsetCommitTimeoutEqualTo(Duration expected) {
        if (!this.actual.getOffsetCommitTimeout().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected OffsetCommitTimeout to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public ProcessingOrderSubject getOrdering() {
        this.isNotNull();
        return (ProcessingOrderSubject)this.check("getOrdering()", new Object[0]).about(ProcessingOrderSubject.processingOrders()).that((Object)this.actual.getOrdering());
    }

    public void hasOrderingNotEqualTo(ParallelConsumerOptions.ProcessingOrder expected) {
        if (this.actual.getOrdering().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected Ordering NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasOrderingEqualTo(ParallelConsumerOptions.ProcessingOrder expected) {
        if (!this.actual.getOrdering().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected Ordering to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public DurationSubject getProduceLockAcquisitionTimeout() {
        this.isNotNull();
        return (DurationSubject)this.check("getProduceLockAcquisitionTimeout()", new Object[0]).about(DurationSubject.durations()).that((Object)this.actual.getProduceLockAcquisitionTimeout());
    }

    public void hasProduceLockAcquisitionTimeoutNotEqualTo(Duration expected) {
        if (this.actual.getProduceLockAcquisitionTimeout().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ProduceLockAcquisitionTimeout NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasProduceLockAcquisitionTimeoutEqualTo(Duration expected) {
        if (!this.actual.getProduceLockAcquisitionTimeout().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ProduceLockAcquisitionTimeout to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public ProducerSubject getProducer() {
        this.isNotNull();
        return (ProducerSubject)this.check("getProducer()", new Object[0]).about(ProducerSubject.producers()).that((Object)this.actual.getProducer());
    }

    public void hasProducerNotEqualTo(Producer expected) {
        if (this.actual.getProducer().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Producer NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasProducerEqualTo(Producer expected) {
        if (!this.actual.getProducer().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Producer to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public FunctionSubject getRetryDelayProvider() {
        this.isNotNull();
        return (FunctionSubject)this.check("getRetryDelayProvider()", new Object[0]).about(FunctionSubject.functions()).that((Object)this.actual.getRetryDelayProvider());
    }

    public void hasRetryDelayProviderNotEqualTo(Function expected) {
        if (this.actual.getRetryDelayProvider().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryDelayProvider NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasRetryDelayProviderEqualTo(Function expected) {
        if (!this.actual.getRetryDelayProvider().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryDelayProvider to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public DurationSubject getSendTimeout() {
        this.isNotNull();
        return (DurationSubject)this.check("getSendTimeout()", new Object[0]).about(DurationSubject.durations()).that((Object)this.actual.getSendTimeout());
    }

    public void hasSendTimeoutNotEqualTo(Duration expected) {
        if (this.actual.getSendTimeout().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected SendTimeout NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasSendTimeoutEqualTo(Duration expected) {
        if (!this.actual.getSendTimeout().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected SendTimeout to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IntegerSubject getTargetAmountOfRecordsInFlight() {
        this.isNotNull();
        return this.check("getTargetAmountOfRecordsInFlight()", new Object[0]).that(Integer.valueOf(this.actual.getTargetAmountOfRecordsInFlight()));
    }

    public void hasTargetAmountOfRecordsInFlightNotEqualTo(int expected) {
        if (this.actual.getTargetAmountOfRecordsInFlight() == expected) {
            this.failWithActual(Fact.fact((String)"expected TargetAmountOfRecordsInFlight NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasTargetAmountOfRecordsInFlightEqualTo(int expected) {
        if (this.actual.getTargetAmountOfRecordsInFlight() != expected) {
            this.failWithActual(Fact.fact((String)"expected TargetAmountOfRecordsInFlight to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public DurationSubject getThresholdForTimeSpendInQueueWarning() {
        this.isNotNull();
        return (DurationSubject)this.check("getThresholdForTimeSpendInQueueWarning()", new Object[0]).about(DurationSubject.durations()).that((Object)this.actual.getThresholdForTimeSpendInQueueWarning());
    }

    public void hasThresholdForTimeSpendInQueueWarningNotEqualTo(Duration expected) {
        if (this.actual.getThresholdForTimeSpendInQueueWarning().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ThresholdForTimeSpendInQueueWarning NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasThresholdForTimeSpendInQueueWarningEqualTo(Duration expected) {
        if (!this.actual.getThresholdForTimeSpendInQueueWarning().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ThresholdForTimeSpendInQueueWarning to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void isAllowEagerProcessingDuringTransactionCommit() {
        if (!this.actual.isAllowEagerProcessingDuringTransactionCommit()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'allow eager processing during transaction commit' (`isAllowEagerProcessingDuringTransactionCommit`)"), new Fact[0]);
        }
    }

    public void isNotAllowEagerProcessingDuringTransactionCommit() {
        if (this.actual.isAllowEagerProcessingDuringTransactionCommit()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'allow eager processing during transaction commit' (`isAllowEagerProcessingDuringTransactionCommit`)"), new Fact[0]);
        }
    }

    public void isProducerSupplied() {
        if (!this.actual.isProducerSupplied()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'producer supplied' (`isProducerSupplied`)"), new Fact[0]);
        }
    }

    public void isNotProducerSupplied() {
        if (this.actual.isProducerSupplied()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'producer supplied' (`isProducerSupplied`)"), new Fact[0]);
        }
    }

    public void isUsingBatching() {
        if (!this.actual.isUsingBatching()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'using batching' (`isUsingBatching`)"), new Fact[0]);
        }
    }

    public void isNotUsingBatching() {
        if (this.actual.isUsingBatching()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'using batching' (`isUsingBatching`)"), new Fact[0]);
        }
    }

    public void isUsingTransactionCommitMode() {
        if (!this.actual.isUsingTransactionCommitMode()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'using transaction commit mode' (`isUsingTransactionCommitMode`)"), new Fact[0]);
        }
    }

    public void isNotUsingTransactionCommitMode() {
        if (this.actual.isUsingTransactionCommitMode()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'using transaction commit mode' (`isUsingTransactionCommitMode`)"), new Fact[0]);
        }
    }

    public void isUsingTransactionalProducer() {
        if (!this.actual.isUsingTransactionalProducer()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'using transactional producer' (`isUsingTransactionalProducer`)"), new Fact[0]);
        }
    }

    public void isNotUsingTransactionalProducer() {
        if (this.actual.isUsingTransactionalProducer()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'using transactional producer' (`isUsingTransactionalProducer`)"), new Fact[0]);
        }
    }
}

