/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import com.google.common.truth.Truth;
import io.confluent.csid.utils.LongPollingMockConsumer;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.ParallelEoSStreamProcessor;
import java.time.Duration;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;

@Tags(value={@Tag(value="transactions"), @Tag(value="#355")})
class ParallelConsumerOptionsTest {
    ParallelConsumerOptionsTest() {
    }

    @Test
    void setTimeBetweenCommits() {
        Duration newFreq = Duration.ofMillis(100L);
        ParallelConsumerOptions options = ParallelConsumerOptions.builder().commitInterval(newFreq).consumer(new LongPollingMockConsumer(OffsetResetStrategy.EARLIEST)).build();
        Truth.assertThat((Comparable)options.getCommitInterval()).isEqualTo((Object)newFreq);
        ParallelEoSStreamProcessor pc = new ParallelEoSStreamProcessor(options);
        Truth.assertThat((Comparable)pc.getTimeBetweenCommits()).isEqualTo((Object)newFreq);
        Duration testFreq = Duration.ofMillis(9L);
        pc.setTimeBetweenCommits(testFreq);
        Truth.assertThat((Comparable)pc.getTimeBetweenCommits()).isEqualTo((Object)testFreq);
        Truth.assertThat((Comparable)options.getCommitInterval()).isEqualTo((Object)testFreq);
    }
}

