/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.Subject;
import io.confluent.parallelconsumer.RecordContext;
import io.confluent.parallelconsumer.autoShaded.java.time.InstantSubject;
import io.confluent.parallelconsumer.state.ConsumerRecordId;
import io.confluent.parallelconsumer.state.ConsumerRecordIdSubject;
import io.stubbs.truth.generator.subjects.MyStringSubject;
import java.time.Instant;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecordSubject;

public class RecordContextParentSubject
extends Subject {
    protected final RecordContext actual;

    protected RecordContextParentSubject(FailureMetadata failureMetadata, RecordContext actual) {
        super(failureMetadata, (Object)actual);
        this.actual = actual;
    }

    public ConsumerRecordSubject getConsumerRecord() {
        this.isNotNull();
        return (ConsumerRecordSubject)this.check("getConsumerRecord()", new Object[0]).about(ConsumerRecordSubject.consumerRecords()).that((Object)this.actual.getConsumerRecord());
    }

    public void hasConsumerRecordNotEqualTo(ConsumerRecord expected) {
        if (this.actual.getConsumerRecord().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ConsumerRecord NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasConsumerRecordEqualTo(ConsumerRecord expected) {
        if (!this.actual.getConsumerRecord().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ConsumerRecord to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public InstantSubject getLastFailureAt() {
        this.isNotNull();
        this.hasLastFailureAtPresent();
        return (InstantSubject)this.check("getLastFailureAt().get()", new Object[0]).about(InstantSubject.instants()).that((Object)((Instant)this.actual.getLastFailureAt().get()));
    }

    public void hasLastFailureAtNotPresent() {
        if (this.actual.getLastFailureAt().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected LastFailureAt NOT to be present"), new Fact[0]);
        }
    }

    public void hasLastFailureAtPresent() {
        if (!this.actual.getLastFailureAt().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected LastFailureAt to be present"), new Fact[0]);
        }
    }

    public void hasLastFailureAtNotEqualTo(Optional expected) {
        if (this.actual.getLastFailureAt().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected LastFailureAt NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasLastFailureAtEqualTo(Optional expected) {
        if (!this.actual.getLastFailureAt().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected LastFailureAt to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IntegerSubject getNumberOfFailedAttempts() {
        this.isNotNull();
        return this.check("getNumberOfFailedAttempts()", new Object[0]).that(Integer.valueOf(this.actual.getNumberOfFailedAttempts()));
    }

    public void hasNumberOfFailedAttemptsNotEqualTo(int expected) {
        if (this.actual.getNumberOfFailedAttempts() == expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfFailedAttempts NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasNumberOfFailedAttemptsEqualTo(int expected) {
        if (this.actual.getNumberOfFailedAttempts() != expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfFailedAttempts to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public ConsumerRecordIdSubject getRecordId() {
        this.isNotNull();
        return (ConsumerRecordIdSubject)this.check("getRecordId()", new Object[0]).about(ConsumerRecordIdSubject.consumerRecordIds()).that((Object)this.actual.getRecordId());
    }

    public void hasRecordIdNotEqualTo(ConsumerRecordId expected) {
        if (this.actual.getRecordId().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected RecordId NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasRecordIdEqualTo(ConsumerRecordId expected) {
        if (!this.actual.getRecordId().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected RecordId to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public InstantSubject getSucceededAt() {
        this.isNotNull();
        this.hasSucceededAtPresent();
        return (InstantSubject)this.check("getSucceededAt().get()", new Object[0]).about(InstantSubject.instants()).that((Object)((Instant)this.actual.getSucceededAt().get()));
    }

    public void hasSucceededAtNotPresent() {
        if (this.actual.getSucceededAt().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected SucceededAt NOT to be present"), new Fact[0]);
        }
    }

    public void hasSucceededAtPresent() {
        if (!this.actual.getSucceededAt().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected SucceededAt to be present"), new Fact[0]);
        }
    }

    public void hasSucceededAtNotEqualTo(Optional expected) {
        if (this.actual.getSucceededAt().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected SucceededAt NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasSucceededAtEqualTo(Optional expected) {
        if (!this.actual.getSucceededAt().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected SucceededAt to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public MyStringSubject hasTopic() {
        this.isNotNull();
        return (MyStringSubject)this.check("topic()", new Object[0]).about(MyStringSubject.strings()).that((Object)this.actual.topic());
    }
}

