/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.autoShaded.java.time;

import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.LongSubject;
import io.stubbs.truth.generator.subjects.MyCollectionSubject;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.List;

public class DurationParentSubject
extends ComparableSubject {
    protected final Duration actual;

    protected DurationParentSubject(FailureMetadata failureMetadata, Duration actual) {
        super(failureMetadata, (Comparable)actual);
        this.actual = actual;
    }

    public IntegerSubject getNano() {
        this.isNotNull();
        return this.check("getNano()", new Object[0]).that(Integer.valueOf(this.actual.getNano()));
    }

    public void hasNanoNotEqualTo(int expected) {
        if (this.actual.getNano() == expected) {
            this.failWithActual(Fact.fact((String)"expected Nano NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasNanoEqualTo(int expected) {
        if (this.actual.getNano() != expected) {
            this.failWithActual(Fact.fact((String)"expected Nano to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public LongSubject getSeconds() {
        this.isNotNull();
        return this.check("getSeconds()", new Object[0]).that(Long.valueOf(this.actual.getSeconds()));
    }

    public void hasSecondsNotEqualTo(long expected) {
        if (this.actual.getSeconds() == expected) {
            this.failWithActual(Fact.fact((String)"expected Seconds NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasSecondsEqualTo(long expected) {
        if (this.actual.getSeconds() != expected) {
            this.failWithActual(Fact.fact((String)"expected Seconds to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public MyCollectionSubject getUnits() {
        this.isNotNull();
        return (MyCollectionSubject)this.check("getUnits()", new Object[0]).about(MyCollectionSubject.collections()).that(this.actual.getUnits());
    }

    public void hasUnitsNotWithElement(TemporalUnit expected) {
        if (!this.actual.getUnits().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected Units NOT to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasUnitsWithElement(TemporalUnit expected) {
        if (this.actual.getUnits().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected Units to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasUnitsNotEqualTo(List expected) {
        if (this.actual.getUnits().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Units NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasUnitsEqualTo(List expected) {
        if (!this.actual.getUnits().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Units to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void isNegative() {
        if (!this.actual.isNegative()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'negative' (`isNegative`)"), new Fact[0]);
        }
    }

    public void isNotNegative() {
        if (this.actual.isNegative()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'negative' (`isNegative`)"), new Fact[0]);
        }
    }

    public void isZero() {
        if (!this.actual.isZero()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'zero' (`isZero`)"), new Fact[0]);
        }
    }

    public void isNotZero() {
        if (this.actual.isZero()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'zero' (`isZero`)"), new Fact[0]);
        }
    }

    public LongSubject hasToDays() {
        this.isNotNull();
        return this.check("toDays()", new Object[0]).that(Long.valueOf(this.actual.toDays()));
    }

    public LongSubject hasToHours() {
        this.isNotNull();
        return this.check("toHours()", new Object[0]).that(Long.valueOf(this.actual.toHours()));
    }

    public LongSubject hasToNanos() {
        this.isNotNull();
        return this.check("toNanos()", new Object[0]).that(Long.valueOf(this.actual.toNanos()));
    }

    public LongSubject hasToMinutes() {
        this.isNotNull();
        return this.check("toMinutes()", new Object[0]).that(Long.valueOf(this.actual.toMinutes()));
    }

    public LongSubject hasToMillis() {
        this.isNotNull();
        return this.check("toMillis()", new Object[0]).that(Long.valueOf(this.actual.toMillis()));
    }
}

