/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.autoShaded.java.util.concurrent.locks;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.Subject;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReentrantReadWriteLockParentSubject
extends Subject {
    protected final ReentrantReadWriteLock actual;

    protected ReentrantReadWriteLockParentSubject(FailureMetadata failureMetadata, ReentrantReadWriteLock actual) {
        super(failureMetadata, (Object)actual);
        this.actual = actual;
    }

    public IntegerSubject getQueueLength() {
        this.isNotNull();
        return this.check("getQueueLength()", new Object[0]).that(Integer.valueOf(this.actual.getQueueLength()));
    }

    public void hasQueueLengthNotEqualTo(int expected) {
        if (this.actual.getQueueLength() == expected) {
            this.failWithActual(Fact.fact((String)"expected QueueLength NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasQueueLengthEqualTo(int expected) {
        if (this.actual.getQueueLength() != expected) {
            this.failWithActual(Fact.fact((String)"expected QueueLength to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IntegerSubject getReadHoldCount() {
        this.isNotNull();
        return this.check("getReadHoldCount()", new Object[0]).that(Integer.valueOf(this.actual.getReadHoldCount()));
    }

    public void hasReadHoldCountNotEqualTo(int expected) {
        if (this.actual.getReadHoldCount() == expected) {
            this.failWithActual(Fact.fact((String)"expected ReadHoldCount NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasReadHoldCountEqualTo(int expected) {
        if (this.actual.getReadHoldCount() != expected) {
            this.failWithActual(Fact.fact((String)"expected ReadHoldCount to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IntegerSubject getReadLockCount() {
        this.isNotNull();
        return this.check("getReadLockCount()", new Object[0]).that(Integer.valueOf(this.actual.getReadLockCount()));
    }

    public void hasReadLockCountNotEqualTo(int expected) {
        if (this.actual.getReadLockCount() == expected) {
            this.failWithActual(Fact.fact((String)"expected ReadLockCount NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasReadLockCountEqualTo(int expected) {
        if (this.actual.getReadLockCount() != expected) {
            this.failWithActual(Fact.fact((String)"expected ReadLockCount to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IntegerSubject getWriteHoldCount() {
        this.isNotNull();
        return this.check("getWriteHoldCount()", new Object[0]).that(Integer.valueOf(this.actual.getWriteHoldCount()));
    }

    public void hasWriteHoldCountNotEqualTo(int expected) {
        if (this.actual.getWriteHoldCount() == expected) {
            this.failWithActual(Fact.fact((String)"expected WriteHoldCount NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasWriteHoldCountEqualTo(int expected) {
        if (this.actual.getWriteHoldCount() != expected) {
            this.failWithActual(Fact.fact((String)"expected WriteHoldCount to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void isFair() {
        if (!this.actual.isFair()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'fair' (`isFair`)"), new Fact[0]);
        }
    }

    public void isNotFair() {
        if (this.actual.isFair()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'fair' (`isFair`)"), new Fact[0]);
        }
    }

    public void isWriteLocked() {
        if (!this.actual.isWriteLocked()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'write locked' (`isWriteLocked`)"), new Fact[0]);
        }
    }

    public void isNotWriteLocked() {
        if (this.actual.isWriteLocked()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'write locked' (`isWriteLocked`)"), new Fact[0]);
        }
    }

    public void isWriteLockedByCurrentThread() {
        if (!this.actual.isWriteLockedByCurrentThread()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'write locked by current thread' (`isWriteLockedByCurrentThread`)"), new Fact[0]);
        }
    }

    public void isNotWriteLockedByCurrentThread() {
        if (this.actual.isWriteLockedByCurrentThread()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'write locked by current thread' (`isWriteLockedByCurrentThread`)"), new Fact[0]);
        }
    }
}

