/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.integrationTests;

import io.confluent.parallelconsumer.integrationTests.BrokerIntegrationTest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public class DbTest
extends BrokerIntegrationTest<String, String> {
    private static final Logger log = LoggerFactory.getLogger(DbTest.class);
    protected static final PostgreSQLContainer dbc = (PostgreSQLContainer)new PostgreSQLContainer().withReuse(true);
    Connection connection;
    static ReentrantLock dbLock;

    @BeforeEach
    public void followDbLogs() {
        if (log.isDebugEnabled()) {
            Slf4jLogConsumer logConsumer = new Slf4jLogConsumer(log);
            dbc.followOutput((Consumer)logConsumer);
        }
    }

    @BeforeEach
    public void setupDatabase() {
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setUrl(dbc.getJdbcUrl());
        dataSource.setUser(dbc.getUsername());
        dataSource.setPassword(dbc.getPassword());
        this.connection = dataSource.getConnection();
        dbLock.lock();
        PreparedStatement create_table = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS DATA(\n   ID SERIAL PRIMARY KEY     NOT NULL,\n   KEY           TEXT    NOT NULL,\n   VALUE         TEXT     NOT NULL\n);");
        create_table.execute();
        dbLock.unlock();
    }

    @Test
    public void testDatabaseSetup() {
        Assertions.assertThat((boolean)dbc.isRunning()).isTrue();
        this.savePayload("a", "test");
    }

    void savePayload(String key, String payload) {
        String query = "insert into data(key, value) values(?, ?)";
        PreparedStatement pst = this.connection.prepareStatement(query);
        pst.setString(1, key);
        pst.setString(2, payload);
        int n = pst.executeUpdate();
    }

    static {
        dbc.start();
        dbLock = new ReentrantLock();
    }
}

