/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.integrationTests;

import io.confluent.csid.utils.ProgressBarUtils;
import io.confluent.csid.utils.StringUtils;
import io.confluent.csid.utils.TrimListRepresentation;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.ParallelEoSStreamProcessor;
import io.confluent.parallelconsumer.integrationTests.BrokerIntegrationTest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.tongfei.progressbar.ProgressBar;
import org.apache.commons.lang3.RandomUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.presentation.Representation;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.tlinkowski.unij.api.UniLists;

public class VeryLargeMessageVolumeTest
extends BrokerIntegrationTest<String, String> {
    private static final Logger log = LoggerFactory.getLogger(VeryLargeMessageVolumeTest.class);
    int HIGH_MAX_POLL_RECORDS_CONFIG = 10000;
    public List<String> consumedKeys = Collections.synchronizedList(new ArrayList());
    public List<String> producedKeysAcknowledged = Collections.synchronizedList(new ArrayList());
    public AtomicInteger processedCount = new AtomicInteger(0);
    public AtomicInteger producedCount = new AtomicInteger(0);

    @Test
    void shouldNotThrowBitSetTooLongException() {
        this.runTest(this.HIGH_MAX_POLL_RECORDS_CONFIG, ParallelConsumerOptions.CommitMode.PERIODIC_CONSUMER_ASYNCHRONOUS, ParallelConsumerOptions.ProcessingOrder.KEY);
    }

    private void runTest(int maxPoll, ParallelConsumerOptions.CommitMode commitMode, ParallelConsumerOptions.ProcessingOrder order) {
        String inputName = this.setupTopic(this.getClass().getSimpleName() + "-input-" + RandomUtils.nextInt());
        String outputName = this.setupTopic(this.getClass().getSimpleName() + "-output-" + RandomUtils.nextInt());
        ArrayList<String> expectedKeys = new ArrayList<String>();
        long expectedMessageCount = 1000000L;
        log.info("Producing {} messages before starting test", (Object)expectedMessageCount);
        ArrayList<Future> sends = new ArrayList<Future>();
        try (KafkaProducer kafkaProducer = this.getKcu().createNewProducer(false);){
            int i = 0;
            while ((long)i < expectedMessageCount) {
                String key = "key-" + i;
                Future send = kafkaProducer.send(new ProducerRecord(inputName, (Object)key, (Object)("value-" + i)), (meta, exception) -> {
                    if (exception != null) {
                        log.error("Error sending, ", (Throwable)exception);
                    }
                });
                sends.add(send);
                expectedKeys.add(key);
                ++i;
            }
            log.debug("Finished sending test data");
        }
        log.debug("Waiting for broker acks");
        for (Future send : sends) {
            send.get();
        }
        Assertions.assertThat(sends).hasSize((int)expectedMessageCount);
        log.debug("Starting test");
        KafkaProducer newProducer = this.getKcu().createNewProducer(commitMode.equals((Object)ParallelConsumerOptions.CommitMode.PERIODIC_TRANSACTIONAL_PRODUCER));
        Properties consumerProps = new Properties();
        consumerProps.put("max.poll.records", (Object)maxPoll);
        KafkaConsumer newConsumer = this.getKcu().createNewConsumer(true, consumerProps);
        ParallelEoSStreamProcessor pc = new ParallelEoSStreamProcessor(ParallelConsumerOptions.builder().ordering(order).consumer(newConsumer).producer(newProducer).commitMode(commitMode).maxConcurrency(1000).build());
        pc.subscribe((Collection)UniLists.of((Object)inputName));
        TopicPartition tp = new TopicPartition(inputName, 0);
        Map beginOffsets = newConsumer.beginningOffsets((Collection)UniLists.of((Object)tp));
        Map endOffsets = newConsumer.endOffsets((Collection)UniLists.of((Object)tp));
        Assertions.assertThat((Map)endOffsets).containsEntry((Object)tp, (Object)expectedMessageCount);
        Assertions.assertThat((Map)beginOffsets).containsEntry((Object)tp, (Object)0L);
        ProgressBar bar = ProgressBarUtils.getNewMessagesBar(log, expectedMessageCount);
        pc.pollAndProduce(record -> {
            bar.stepBy(1L);
            this.consumedKeys.add((String)record.key());
            this.processedCount.incrementAndGet();
            return new ProducerRecord(outputName, (Object)((String)record.key()), (Object)"data");
        }, consumeProduceResult -> {
            this.producedCount.incrementAndGet();
            this.producedKeysAcknowledged.add((String)consumeProduceResult.getIn().key());
        });
        Assertions.useRepresentation((Representation)new TrimListRepresentation());
        String failureMessage = StringUtils.msg((String)"All keys sent to input-topic should be processed and produced, within time (expected: {} commit: {} order: {} max poll: {})", (Object[])new Object[]{expectedMessageCount, commitMode, order, maxPoll});
        try {
            Awaitility.waitAtMost((Duration)Duration.ofSeconds(120L)).failFast("PC died - check logs", () -> ((ParallelEoSStreamProcessor)pc).isClosedOrFailed()).alias(failureMessage).pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> {
                log.trace("Processed-count: {}, Produced-count: {}", (Object)this.processedCount.get(), (Object)this.producedCount.get());
                SoftAssertions all = new SoftAssertions();
                ((ListAssert)all.assertThat(new ArrayList<String>(this.consumedKeys)).as("all expected are consumed", new Object[0])).hasSameSizeAs((Iterable)expectedKeys);
                ((ListAssert)all.assertThat(new ArrayList<String>(this.producedKeysAcknowledged)).as("all consumed are produced ok ", new Object[0])).hasSameSizeAs((Iterable)expectedKeys);
                all.assertAll();
            });
        }
        catch (ConditionTimeoutException e) {
            Assertions.fail((String)(failureMessage + "\n" + e.getMessage()));
        }
        bar.close();
        pc.closeDrainFirst();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.processedCount.get()).as("messages processed and produced by parallel-consumer should be equal", new Object[0])).isEqualTo(this.producedCount.get());
        Assertions.assertThat((long)expectedMessageCount).isEqualTo((long)this.processedCount.get());
        Assertions.assertThat(this.producedKeysAcknowledged).hasSameSizeAs(expectedKeys);
    }
}

