/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.integrationTests.state;

import com.google.common.truth.StringSubject;
import com.google.common.truth.Truth;
import io.confluent.csid.utils.JavaUtils;
import io.confluent.csid.utils.ThreadUtils;
import io.confluent.parallelconsumer.FakeRuntimeException;
import io.confluent.parallelconsumer.ManagedTruth;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.ParallelEoSStreamProcessor;
import io.confluent.parallelconsumer.PollContext;
import io.confluent.parallelconsumer.integrationTests.BrokerIntegrationTest;
import io.confluent.parallelconsumer.integrationTests.utils.KafkaClientUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.awaitility.Awaitility;
import org.awaitility.core.TerminalFailureException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.KafkaContainer;
import pl.tlinkowski.unij.api.UniLists;
import pl.tlinkowski.unij.api.UniMaps;
import pl.tlinkowski.unij.api.UniSets;

class PartitionStateCommittedOffsetIT
extends BrokerIntegrationTest<String, String> {
    private static final Logger log = LoggerFactory.getLogger(PartitionStateCommittedOffsetIT.class);
    public static final OffsetResetStrategy DEFAULT_OFFSET_RESET_POLICY = OffsetResetStrategy.EARLIEST;
    TopicPartition tp;
    int TO_PRODUCE = 200;
    private OffsetResetStrategy offsetResetStrategy = DEFAULT_OFFSET_RESET_POLICY;
    private ParallelEoSStreamProcessor<String, String> activePc;

    PartitionStateCommittedOffsetIT() {
    }

    @BeforeEach
    void setup() {
        this.setupTopic();
        this.tp = new TopicPartition(this.getTopic(), 0);
    }

    @Test
    void compactedTopic() {
        try (KafkaContainer compactingBroker = this.setupCompactingKafkaBroker();){
            int TO_PRODUCE = this.TO_PRODUCE / 10;
            List<String> keys = this.produceMessages(TO_PRODUCE);
            int UNTIL_OFFSET = TO_PRODUCE / 2;
            List<PollContext<String, String>> processedOnFirstRun = this.runPcUntilOffset(UNTIL_OFFSET, TO_PRODUCE, UniSets.of((Object)((long)TO_PRODUCE - 3L)));
            Truth.assertWithMessage((String)"Last processed should be at least half of the total sent, so that there is incomplete data to track").that(Long.valueOf(((PollContext)JavaUtils.getLast(processedOnFirstRun).get()).offset())).isGreaterThan(TO_PRODUCE / 2);
            ArrayList<String> compactionKeysRaw = this.sendRandomCompactionRecords(keys, TO_PRODUCE);
            HashSet<String> compactedKeys = new HashSet<String>(compactionKeysRaw);
            List processedOnFirstRunWithTombstoneTargetsRemoved = processedOnFirstRun.stream().filter(context -> !compactedKeys.contains(context.key())).map(PollContext::key).collect(Collectors.toList());
            Map<Boolean, List<PollContext>> firstRunPartitioned = processedOnFirstRun.stream().collect(Collectors.partitioningBy(context -> compactedKeys.contains(context.key())));
            List<PollContext> saved = firstRunPartitioned.get(Boolean.FALSE);
            List<PollContext> compacted = firstRunPartitioned.get(Boolean.TRUE);
            log.debug("kept offsets: {}", saved.stream().mapToLong(PollContext::offset).boxed().collect(Collectors.toList()));
            log.debug("kept keys: {}", saved.stream().map(PollContext::key).collect(Collectors.toList()));
            log.debug("compacted offsets: {}", compacted.stream().map(PollContext::key).collect(Collectors.toList()));
            log.debug("compacted keys: {}", compacted.stream().mapToLong(PollContext::offset).boxed().collect(Collectors.toList()));
            List tombstoneTargetOffsetsFromFirstRun = compacted.stream().filter(context -> compactedKeys.contains(context.key())).map(PollContext::offset).collect(Collectors.toList());
            List tombStonedOffsetsFromKey = compactedKeys.stream().map(PartitionStateCommittedOffsetIT::getOffsetFromKey).collect(Collectors.toList());
            log.debug("First run produced, with compaction targets removed: {}", processedOnFirstRunWithTombstoneTargetsRemoved);
            this.triggerCompactionProcessing();
            int expectedOffsetProcessedToSecondRun = TO_PRODUCE + compactedKeys.size();
            List processedOnSecondRun = this.runPcUntilOffset(expectedOffsetProcessedToSecondRun, KafkaClientUtils.GroupOption.REUSE_GROUP).stream().filter(recordContexts -> !((String)recordContexts.key()).contains("compaction-trigger")).collect(Collectors.toList());
            List offsetsFromSecond = processedOnSecondRun.stream().map(PollContext::offset).collect(Collectors.toList());
            Truth.assertWithMessage((String)"Finish reading rest of records from %s to %s", (Object[])new Object[]{UNTIL_OFFSET, TO_PRODUCE}).that(Integer.valueOf(processedOnSecondRun.size())).isGreaterThan((Comparable)Integer.valueOf(TO_PRODUCE - UNTIL_OFFSET));
            Truth.assertWithMessage((String)"Off the offsets read on the second run, offsets that were compacted (below the initial produce target) should now be removed, as they were replaced with newer ones.").that(offsetsFromSecond).containsNoneIn(tombstoneTargetOffsetsFromFirstRun);
        }
    }

    @NonNull
    private KafkaContainer setupCompactingKafkaBroker() {
        KafkaContainer compactingBroker = null;
        compactingBroker = BrokerIntegrationTest.createKafkaContainer("40000");
        compactingBroker.start();
        this.setup();
        this.setupCompactedEnvironment();
        return compactingBroker;
    }

    private List<PollContext<String, String>> runPcUntilOffset(int offset) {
        return this.runPcUntilOffset(DEFAULT_OFFSET_RESET_POLICY, offset);
    }

    private List<PollContext<String, String>> runPcUntilOffset(OffsetResetStrategy offsetResetPolicy, int offset) {
        return this.runPcUntilOffset(offsetResetPolicy, offset, offset, UniSets.of(), KafkaClientUtils.GroupOption.NEW_GROUP);
    }

    private List<PollContext<String, String>> runPcUntilOffset(int offset, KafkaClientUtils.GroupOption reuseGroup) {
        return this.runPcUntilOffset(DEFAULT_OFFSET_RESET_POLICY, Long.MAX_VALUE, offset, UniSets.of(), reuseGroup);
    }

    private static long getOffsetFromKey(String key) {
        return Long.parseLong(key.substring(key.indexOf("-") + 1));
    }

    private void setupCompactedEnvironment() {
        log.debug("Setting up aggressive compaction...");
        ConfigResource topicConfig = new ConfigResource(ConfigResource.Type.TOPIC, this.getTopic());
        ArrayList<AlterConfigOp> alterConfigOps = new ArrayList<AlterConfigOp>();
        alterConfigOps.add(new AlterConfigOp(new ConfigEntry("cleanup.policy", "compact"), AlterConfigOp.OpType.SET));
        alterConfigOps.add(new AlterConfigOp(new ConfigEntry("max.compaction.lag.ms", "1"), AlterConfigOp.OpType.SET));
        alterConfigOps.add(new AlterConfigOp(new ConfigEntry("min.cleanable.dirty.ratio", "0"), AlterConfigOp.OpType.SET));
        Map configs = UniMaps.of((Object)topicConfig, alterConfigOps);
        KafkaFuture all = this.getKcu().getAdmin().incrementalAlterConfigs(configs).all();
        all.get(5L, TimeUnit.SECONDS);
        log.debug("Compaction setup complete");
    }

    private List<String> triggerCompactionProcessing() {
        List<String> keys = this.produceMessages(this.TO_PRODUCE * 2, "log-compaction-trigger-");
        int pauseSeconds = 20;
        log.info("Pausing for {} seconds to allow for compaction", (Object)20);
        ThreadUtils.sleepSecondsLog(20);
        return keys;
    }

    private ArrayList<String> sendRandomCompactionRecords(List<String> keys, int howMany) {
        ArrayList<String> tombstoneKeys = new ArrayList<String>();
        List futures = JavaUtils.getRandom(keys, (int)howMany).stream().map(key -> {
            tombstoneKeys.add((String)key);
            ProducerRecord tombstone = new ProducerRecord(this.getTopic(), key, (Object)"compactor");
            return this.getKcu().getProducer().send(tombstone);
        }).collect(Collectors.toList());
        ArrayList<Long> tombstoneOffsets = new ArrayList<Long>();
        for (Future future : futures) {
            RecordMetadata recordMetadata = (RecordMetadata)future.get(5L, TimeUnit.SECONDS);
            tombstoneOffsets.add(recordMetadata.offset());
        }
        tombstoneKeys.sort(Comparator.comparingLong(PartitionStateCommittedOffsetIT::getOffsetFromKey));
        log.debug("Keys to tombstone: {}\nOffsets of the generated tombstone: {}", tombstoneKeys, tombstoneOffsets);
        return tombstoneKeys;
    }

    @Test
    void committedOffsetLower() {
        this.produceMessages(this.TO_PRODUCE);
        this.runPcUntilOffset(50);
        int moveToOffset = 25;
        this.moveCommittedOffset(this.getKcu().getGroupId(), 25L);
        this.runPcCheckStartIs(25, this.TO_PRODUCE);
    }

    private void runPcCheckStartIs(long targetStartOffset, long checkUpTo, KafkaClientUtils.GroupOption groupOption) {
        ParallelEoSStreamProcessor<String, String> tempPc = super.getKcu().buildPc(ParallelConsumerOptions.ProcessingOrder.PARTITION, groupOption);
        tempPc.subscribe((Collection)UniLists.of((Object)this.getTopic()));
        AtomicLong lowest = new AtomicLong(Long.MAX_VALUE);
        AtomicLong highest = new AtomicLong(Long.MIN_VALUE);
        AtomicLong bumpersSent = new AtomicLong();
        tempPc.poll(recordContexts -> {
            log.error("Consumed: {} Bumpers sent {}", (Object)recordContexts.offset(), (Object)bumpersSent);
            long thisOffset = recordContexts.offset();
            if (thisOffset < lowest.get()) {
                log.error("Found lowest offset {}", (Object)thisOffset);
                lowest.set(thisOffset);
            } else if (thisOffset > highest.get()) {
                highest.set(thisOffset);
            }
        });
        if (this.offsetResetStrategy.equals((Object)OffsetResetStrategy.NONE)) {
            Awaitility.await().untilAsserted(() -> Truth.assertThat((Boolean)tempPc.isClosedOrFailed()).isFalse());
            Awaitility.await().untilAsserted(() -> Truth.assertThat((Boolean)tempPc.isClosedOrFailed()).isTrue());
            Exception throwable = tempPc.getFailureCause();
            StringSubject causeMessage = Truth.assertThat((String)ExceptionUtils.getRootCauseMessage((Throwable)throwable));
            causeMessage.contains((CharSequence)"NoOffsetForPartitionException");
            causeMessage.contains((CharSequence)"Undefined offset with no reset policy");
            this.getKcu().close();
        } else {
            Awaitility.await().pollInterval(5L, TimeUnit.SECONDS).atMost(30L, TimeUnit.SECONDS).failFast(() -> tempPc.isClosedOrFailed()).untilAsserted(() -> {
                this.getKcu().getProducer().send(new ProducerRecord(this.getTopic(), (Object)"key-bumper", (Object)"poll-bumper"));
                bumpersSent.incrementAndGet();
                long endOffset = ((ListOffsetsResult.ListOffsetsResultInfo)this.getKcu().getAdmin().listOffsets(UniMaps.of((Object)this.tp, (Object)OffsetSpec.earliest())).partitionResult(this.tp).get()).offset();
                long startOffset = ((ListOffsetsResult.ListOffsetsResultInfo)this.getKcu().getAdmin().listOffsets(UniMaps.of((Object)this.tp, (Object)OffsetSpec.latest())).partitionResult(this.tp).get()).offset();
                log.error("start await loop: {}, end: {}, bumpersSent: {}", new Object[]{startOffset, endOffset, bumpersSent});
                Truth.assertWithMessage((String)"Highest seen offset to read up to").that(Long.valueOf(highest.get())).isAtLeast((Comparable)Long.valueOf(checkUpTo - 1L));
            });
            log.warn("Offset started at should equal the target {}, lowest {}, sent {}, diff is {})", new Object[]{targetStartOffset, lowest, bumpersSent, lowest.get() - targetStartOffset});
            Truth.assertWithMessage((String)"Offset started at should equal the target (sent %s , diff is %s)", (Object[])new Object[]{bumpersSent, lowest.get() - targetStartOffset}).that(Long.valueOf(lowest.get())).isEqualTo((Object)targetStartOffset);
            tempPc.close();
        }
    }

    private void moveCommittedOffset(String groupId, long offset) {
        log.debug("Moving offset of {} to {}", (Object)groupId, (Object)offset);
        Map data = UniMaps.of((Object)this.tp, (Object)new OffsetAndMetadata(offset));
        AlterConsumerGroupOffsetsResult result = this.getKcu().getAdmin().alterConsumerGroupOffsets(groupId, data);
        result.all().get(5L, TimeUnit.SECONDS);
        log.debug("Moved offset to {}", (Object)offset);
    }

    private List<PollContext<String, String>> runPcUntilOffset(long succeedUpToOffset, long expectedProcessToOffset, Set<Long> exceptionsToSucceed) {
        return this.runPcUntilOffset(DEFAULT_OFFSET_RESET_POLICY, succeedUpToOffset, expectedProcessToOffset, exceptionsToSucceed, KafkaClientUtils.GroupOption.NEW_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PollContext<String, String>> runPcUntilOffset(OffsetResetStrategy offsetResetPolicy, long succeedUpToOffset, long expectedProcessToOffset, Set<Long> exceptionsToSucceed, KafkaClientUtils.GroupOption newGroup) {
        ArrayList<PollContext<String, String>> arrayList;
        log.debug("Running PC until at least offset {}", (Object)succeedUpToOffset);
        super.getKcu().setOffsetResetPolicy(offsetResetPolicy);
        ParallelEoSStreamProcessor<String, String> tempPc = super.getKcu().buildPc(ParallelConsumerOptions.ProcessingOrder.UNORDERED, newGroup);
        this.activePc = tempPc;
        try {
            SortedSet<PollContext> seenOffsets = Collections.synchronizedSortedSet(new TreeSet<PollContext>(Comparator.comparingLong(PollContext::offset)));
            SortedSet<PollContext> succeededOffsets = Collections.synchronizedSortedSet(new TreeSet<PollContext>(Comparator.comparingLong(PollContext::offset)));
            tempPc.subscribe((Collection)UniLists.of((Object)this.getTopic()));
            tempPc.poll(pollContext -> {
                seenOffsets.add((PollContext)pollContext);
                long thisOffset = pollContext.offset();
                if (exceptionsToSucceed.contains(thisOffset)) {
                    log.debug("Exceptional offset {} succeeded", (Object)thisOffset);
                } else {
                    if (thisOffset >= succeedUpToOffset) {
                        log.debug("Failing on {}", (Object)thisOffset);
                        throw new FakeRuntimeException("Failing on " + thisOffset);
                    }
                    log.debug("Succeeded {}: {}", (Object)thisOffset, (Object)pollContext.getSingleRecord());
                    succeededOffsets.add((PollContext)pollContext);
                }
            });
            ThreadUtils.sleepSecondsLog(1);
            this.getKcu().produceMessages(this.getTopic(), 1L, "poll-bumper");
            Awaitility.await().failFast(() -> tempPc.isClosedOrFailed()).untilAsserted(() -> {
                Truth.assertThat((Iterable)seenOffsets).isNotEmpty();
                Truth.assertThat((Long)((PollContext)seenOffsets.last()).offset()).isGreaterThan((Comparable)Long.valueOf(expectedProcessToOffset - 2L));
            });
            if (!succeededOffsets.isEmpty()) {
                log.debug("Succeeded up to: {}", (Object)succeededOffsets.last().offset());
            }
            log.debug("Consumed up to {}", (Object)seenOffsets.last().offset());
            ArrayList<PollContext<String, String>> sorted = new ArrayList<PollContext<String, String>>(seenOffsets);
            Collections.sort(sorted, Comparator.comparingLong(PollContext::offset));
            arrayList = sorted;
        }
        catch (Throwable throwable) {
            try {
                if (!tempPc.isClosedOrFailed()) {
                    tempPc.close();
                }
            }
            catch (Exception e) {
                log.debug("Cause will get rethrown close on the NONE parameter branch", (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (!tempPc.isClosedOrFailed()) {
                tempPc.close();
            }
        }
        catch (Exception e) {
            log.debug("Cause will get rethrown close on the NONE parameter branch", (Throwable)e);
        }
        return arrayList;
    }

    @Test
    void committedOffsetHigher() {
        int quantity = 100;
        this.produceMessages(100);
        this.runPcUntilOffset(50);
        int moveToOffset = 75;
        this.moveCommittedOffset(this.getKcu().getGroupId(), 75L);
        this.runPcCheckStartIs(75, 100);
    }

    private void runPcCheckStartIs(int targetStartOffset, int checkUpTo) {
        this.runPcCheckStartIs(targetStartOffset, checkUpTo, KafkaClientUtils.GroupOption.REUSE_GROUP);
    }

    @EnumSource(value=OffsetResetStrategy.class)
    @ParameterizedTest
    void committedOffsetRemoved(OffsetResetStrategy offsetResetPolicy) {
        this.offsetResetStrategy = offsetResetPolicy;
        try (KafkaContainer compactingKafkaBroker = this.setupCompactingKafkaBroker();
             KafkaClientUtils clientUtils = new KafkaClientUtils(compactingKafkaBroker);){
            int n;
            log.debug("Compacting broker started {}", (Object)compactingKafkaBroker.getBootstrapServers());
            clientUtils.setOffsetResetPolicy(offsetResetPolicy);
            clientUtils.open();
            if (offsetResetPolicy.equals((Object)OffsetResetStrategy.NONE)) {
                KafkaConsumer<String, String> consumer = this.getKcu().getConsumer();
                consumer.subscribe((Collection)UniLists.of((Object)this.getTopic()));
                consumer.poll(Duration.ofSeconds(1L));
                consumer.commitSync(UniMaps.of((Object)this.tp, (Object)new OffsetAndMetadata(0L)));
                consumer.close();
            }
            int producedCount = this.produceMessages(this.TO_PRODUCE).size();
            int END_OFFSET = 50;
            String groupId = clientUtils.getGroupId();
            this.runPcUntilOffset(offsetResetPolicy, 50L, 50L, UniSets.of(), KafkaClientUtils.GroupOption.REUSE_GROUP);
            ++producedCount;
            String compactedKey = "key-50";
            this.checkHowManyRecordsWithKeyPresent("key-50", 1, this.TO_PRODUCE);
            int triggerRecordsCount = this.causeCommittedOffsetToBeRemoved(50L);
            this.checkHowManyRecordsWithKeyPresent("key-50", 1, this.TO_PRODUCE + 2);
            producedCount += triggerRecordsCount;
            switch (offsetResetPolicy) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case EARLIEST: {
                    n = 0;
                    break;
                }
                case LATEST: {
                    n = producedCount;
                    break;
                }
                case NONE: {
                    n = -1;
                }
            }
            int EXPECTED_RESET_OFFSET = n;
            clientUtils.setGroupId(groupId);
            this.runPcCheckStartIs(EXPECTED_RESET_OFFSET, producedCount);
        }
    }

    private void checkHowManyRecordsWithKeyPresent(String keyToSearchFor, int expectedQuantityToFind, long searchUpToOffset) {
        log.debug("Looking for {} records with key {} up to offset {}", new Object[]{expectedQuantityToFind, keyToSearchFor, searchUpToOffset});
        try (KafkaConsumer newConsumer = this.getKcu().createNewConsumer(KafkaClientUtils.GroupOption.NEW_GROUP);){
            newConsumer.assign((Collection)UniLists.of((Object)this.tp));
            newConsumer.seekToBeginning((Collection)UniSets.of((Object)this.tp));
            long positionAfter = newConsumer.position(this.tp);
            Truth.assertThat((Long)positionAfter).isEqualTo((Object)0);
            ArrayList records = new ArrayList();
            long highest = -1L;
            while (highest < searchUpToOffset - 1L) {
                ConsumerRecords poll = newConsumer.poll(Duration.ofSeconds(1L));
                records.addAll(poll.records(this.tp));
                Optional lastOpt = JavaUtils.getLast(records);
                if (!lastOpt.isPresent()) continue;
                highest = ((ConsumerRecord)lastOpt.get()).offset();
            }
            List collect = records.stream().filter(value -> ((String)value.key()).equals(keyToSearchFor)).collect(Collectors.toList());
            ManagedTruth.assertThat(collect).hasSize(expectedQuantityToFind);
        }
    }

    private int causeCommittedOffsetToBeRemoved(long offset) {
        this.sendCompactionKeyForOffset(offset);
        this.sendCompactionKeyForOffset(offset + 1L);
        this.checkHowManyRecordsWithKeyPresent("key-" + offset, 2, this.TO_PRODUCE + 2);
        List<String> strings = this.triggerCompactionProcessing();
        return 2 + strings.size();
    }

    private void sendCompactionKeyForOffset(long offset) throws InterruptedException, ExecutionException, TimeoutException {
        String key = "key-" + offset;
        ProducerRecord compactingRecord = new ProducerRecord(this.getTopic(), Integer.valueOf(0), (Object)key, (Object)"compactor");
        this.getKcu().getProducer().send(compactingRecord).get(1L, TimeUnit.SECONDS);
    }

    @Test
    void noOffsetPolicyOnStartup() {
        this.offsetResetStrategy = OffsetResetStrategy.NONE;
        try (KafkaClientUtils clientUtils = new KafkaClientUtils(kafkaContainer);){
            clientUtils.setOffsetResetPolicy(this.offsetResetStrategy);
            clientUtils.open();
            int producedCount = this.produceMessages(this.TO_PRODUCE).size();
            try {
                this.runPcUntilOffset(this.offsetResetStrategy, producedCount, producedCount, UniSets.of(), KafkaClientUtils.GroupOption.REUSE_GROUP);
            }
            catch (TerminalFailureException e) {
                Exception failureCause = this.activePc.getFailureCause();
                String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)failureCause);
                StringSubject message = Truth.assertThat((String)rootCauseMessage);
                message.contains((CharSequence)"NoOffsetForPartitionException");
                message.contains((CharSequence)"Undefined offset");
                message.contains((CharSequence)"no reset policy");
            }
        }
    }
}

