/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.internal.ConsumerManager;
import io.confluent.parallelconsumer.internal.DynamicLoadFactor;
import io.confluent.parallelconsumer.internal.LimitedDynamicExtraLoadFactor;
import io.confluent.parallelconsumer.internal.PCModule;
import io.confluent.parallelconsumer.internal.PausableWorkManager;
import io.confluent.parallelconsumer.internal.ProducerWrapper;
import io.confluent.parallelconsumer.state.ModelUtils;
import io.confluent.parallelconsumer.state.WorkManager;
import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import lombok.NonNull;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.mockito.Mockito;
import org.threeten.extra.MutableClock;

public class PCModuleTestEnv
extends PCModule<String, String> {
    ModelUtils mu = new ModelUtils(this);
    Optional<CountDownLatch> workManagerController;
    private WorkManager<String, String> workManager;
    private final DynamicLoadFactor limitedDynamicLoadFactor = new LimitedDynamicExtraLoadFactor();
    ProducerWrapper<String, String> mockProduceWrap;
    private final MutableClock mutableClock = MutableClock.epochUTC();

    protected DynamicLoadFactor dynamicExtraLoadFactor() {
        return this.limitedDynamicLoadFactor;
    }

    public PCModuleTestEnv(ParallelConsumerOptions<String, String> optionsInstance, CountDownLatch latch) {
        super(optionsInstance);
        this.workManagerController = Optional.of(latch);
    }

    public PCModuleTestEnv(ParallelConsumerOptions<String, String> optionsInstance) {
        super(optionsInstance);
        ParallelConsumerOptions<String, String> override;
        this.optionsInstance = override = this.enhanceOptions(optionsInstance);
        this.workManagerController = Optional.empty();
    }

    private ParallelConsumerOptions<String, String> enhanceOptions(ParallelConsumerOptions<String, String> optionsInstance) {
        ParallelConsumerOptions.ParallelConsumerOptionsBuilder copy = this.options().toBuilder();
        if (optionsInstance.getConsumer() == null) {
            Consumer mockConsumer = (Consumer)Mockito.mock(Consumer.class);
            Mockito.when((Object)mockConsumer.groupMetadata()).thenReturn((Object)this.mu.consumerGroupMeta());
            copy.consumer(mockConsumer);
        }
        ParallelConsumerOptions override = copy.producer((Producer)Mockito.mock(Producer.class)).build();
        return override;
    }

    public PCModuleTestEnv() {
        this((ParallelConsumerOptions<String, String>)ParallelConsumerOptions.builder().build());
    }

    protected ProducerWrapper<String, String> producerWrap() {
        return this.mockProducerWrapTransactional();
    }

    @NonNull
    private ProducerWrapper<String, String> mockProducerWrapTransactional() {
        if (this.mockProduceWrap == null) {
            this.mockProduceWrap = (ProducerWrapper)Mockito.spy((Object)new ProducerWrapper(this.options(), true, this.producer()));
        }
        return this.mockProduceWrap;
    }

    public WorkManager<String, String> workManager() {
        if (this.workManager == null) {
            this.workManager = this.workManagerController.isPresent() ? new PausableWorkManager<String, String>(this, this.dynamicExtraLoadFactor(), this.workManagerController.get()) : super.workManager();
        }
        return this.workManager;
    }

    protected ConsumerManager<String, String> consumerManager() {
        ConsumerManager consumerManager = super.consumerManager();
        consumerManager.updateMetadataCache();
        return consumerManager;
    }

    public Clock clock() {
        return this.mutableClock;
    }

    public MutableClock getMutableClock() {
        return this.mutableClock;
    }
}

