/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import io.confluent.parallelconsumer.internal.DynamicLoadFactor;
import io.confluent.parallelconsumer.internal.PCModule;
import io.confluent.parallelconsumer.state.WorkContainer;
import io.confluent.parallelconsumer.state.WorkManager;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PausableWorkManager<K, V>
extends WorkManager<K, V> {
    private static final Logger log = LoggerFactory.getLogger(PausableWorkManager.class);
    private final Optional<CountDownLatch> optionalCountDownLatch;

    public PausableWorkManager(PCModule<K, V> module, DynamicLoadFactor dynamicExtraLoadFactor, CountDownLatch latchToControlWorkIfAvailable) {
        super(module, dynamicExtraLoadFactor);
        this.optionalCountDownLatch = Optional.of(latchToControlWorkIfAvailable);
    }

    public List<WorkContainer<K, V>> getWorkIfAvailable(int requestedMaxWorkToRetrieve) {
        List workContainers = super.getWorkIfAvailable(requestedMaxWorkToRetrieve);
        if (workContainers.size() > 0) {
            this.optionalCountDownLatch.ifPresent(this::awaitLatch);
        }
        return workContainers;
    }

    void awaitLatch(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            log.debug("Expected the exception on rebalance, continue..", (Throwable)ex);
        }
    }
}

