/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import io.confluent.parallelconsumer.autoShaded.java.util.concurrent.locks.ReentrantReadWriteLockSubject;
import io.confluent.parallelconsumer.internal.ProducerManager;
import io.confluent.parallelconsumer.internal.ProducerWrapper;
import io.confluent.parallelconsumer.internal.ProducerWrapperSubject;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ProducerManagerParentSubject
extends Subject {
    protected final ProducerManager actual;

    protected ProducerManagerParentSubject(FailureMetadata failureMetadata, ProducerManager actual) {
        super(failureMetadata, (Object)actual);
        this.actual = actual;
    }

    public ReentrantReadWriteLockSubject getProducerTransactionLock() {
        this.isNotNull();
        return (ReentrantReadWriteLockSubject)this.check("getProducerTransactionLock()", new Object[0]).about(ReentrantReadWriteLockSubject.reentrantReadWriteLocks()).that((Object)this.actual.getProducerTransactionLock());
    }

    public void hasProducerTransactionLockNotEqualTo(ReentrantReadWriteLock expected) {
        if (this.actual.getProducerTransactionLock().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ProducerTransactionLock NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasProducerTransactionLockEqualTo(ReentrantReadWriteLock expected) {
        if (!this.actual.getProducerTransactionLock().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ProducerTransactionLock to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public ProducerWrapperSubject getProducerWrapper() {
        this.isNotNull();
        return (ProducerWrapperSubject)this.check("getProducerWrapper()", new Object[0]).about(ProducerWrapperSubject.producerWrappers()).that((Object)this.actual.getProducerWrapper());
    }

    public void hasProducerWrapperNotEqualTo(ProducerWrapper expected) {
        if (this.actual.getProducerWrapper().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ProducerWrapper NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasProducerWrapperEqualTo(ProducerWrapper expected) {
        if (!this.actual.getProducerWrapper().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected ProducerWrapper to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void isTransactionCommittingInProgress() {
        if (!this.actual.isTransactionCommittingInProgress()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'transaction committing in progress' (`isTransactionCommittingInProgress`)"), new Fact[0]);
        }
    }

    public void isNotTransactionCommittingInProgress() {
        if (this.actual.isTransactionCommittingInProgress()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'transaction committing in progress' (`isTransactionCommittingInProgress`)"), new Fact[0]);
        }
    }
}

