/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.internal;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import io.confluent.parallelconsumer.internal.ProducerStateSubject;
import io.confluent.parallelconsumer.internal.ProducerWrapper;

public class ProducerWrapperParentSubject
extends Subject {
    protected final ProducerWrapper actual;

    protected ProducerWrapperParentSubject(FailureMetadata failureMetadata, ProducerWrapper actual) {
        super(failureMetadata, (Object)actual);
        this.actual = actual;
    }

    public ProducerStateSubject getProducerState() {
        this.isNotNull();
        return (ProducerStateSubject)this.check("getProducerState()", new Object[0]).about(ProducerStateSubject.producerStates()).that((Object)this.actual.getProducerState());
    }

    public void hasProducerStateNotEqualTo(ProducerWrapper.ProducerState expected) {
        if (this.actual.getProducerState().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected ProducerState NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasProducerStateEqualTo(ProducerWrapper.ProducerState expected) {
        if (!this.actual.getProducerState().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected ProducerState to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void isConfiguredForTransactions() {
        if (!this.actual.isConfiguredForTransactions()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'configured for transactions' (`isConfiguredForTransactions`)"), new Fact[0]);
        }
    }

    public void isNotConfiguredForTransactions() {
        if (this.actual.isConfiguredForTransactions()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'configured for transactions' (`isConfiguredForTransactions`)"), new Fact[0]);
        }
    }

    public void isMockProducer() {
        if (!this.actual.isMockProducer()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'mock producer' (`isMockProducer`)"), new Fact[0]);
        }
    }

    public void isNotMockProducer() {
        if (this.actual.isMockProducer()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'mock producer' (`isMockProducer`)"), new Fact[0]);
        }
    }

    public void isTransactionOpen() {
        if (!this.actual.isTransactionOpen()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'transaction open' (`isTransactionOpen`)"), new Fact[0]);
        }
    }

    public void isNotTransactionOpen() {
        if (this.actual.isTransactionOpen()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'transaction open' (`isTransactionOpen`)"), new Fact[0]);
        }
    }
}

