/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.model;

import io.confluent.csid.utils.CollectionUtils;
import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;

public class CommitHistory {
    private final List<OffsetAndMetadata> history;

    public CommitHistory(List<OffsetAndMetadata> collect) {
        this.history = collect;
    }

    public boolean contains(int offset) {
        return this.history.stream().anyMatch(x -> x.offset() == (long)offset);
    }

    public Optional<Long> highestCommit() {
        Optional<OffsetAndMetadata> last = CollectionUtils.getLast(this.history);
        return last.map(OffsetAndMetadata::offset);
    }

    public List<Long> getOffsetHistory() {
        return this.history.stream().map(OffsetAndMetadata::offset).collect(Collectors.toList());
    }

    public OffsetMapCodecManager.HighestOffsetAndIncompletes getEncodedSucceeded() {
        Optional<OffsetAndMetadata> first = this.getHead();
        OffsetAndMetadata offsetAndMetadata = first.get();
        OffsetMapCodecManager.HighestOffsetAndIncompletes highestOffsetAndIncompletes = OffsetMapCodecManager.deserialiseIncompleteOffsetMapFromBase64((long)offsetAndMetadata.offset(), (String)offsetAndMetadata.metadata());
        return highestOffsetAndIncompletes;
    }

    @NonNull
    private Optional<OffsetAndMetadata> getHead() {
        Optional<OffsetAndMetadata> first = this.history.isEmpty() ? Optional.empty() : Optional.of(this.history.get(this.history.size() - 1));
        return first;
    }

    public String getEncoding() {
        return this.getHead().get().metadata();
    }
}

