/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.csid.utils.JavaUtils;
import io.confluent.parallelconsumer.offsets.BitSetEncoder;
import io.confluent.parallelconsumer.offsets.EncodedOffsetPair;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import io.confluent.parallelconsumer.offsets.OffsetSimultaneousEncoder;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import pl.tlinkowski.unij.api.UniLists;
import pl.tlinkowski.unij.api.UniSets;

class BitSetEncodingTest {
    BitSetEncodingTest() {
    }

    @Test
    void basic() {
        TreeSet incompletes = (TreeSet)UniSets.of((Object)0, (Object)4, (Object)6, (Object)7, (Object)8, (Object)10).stream().map(x -> (long)x).collect(JavaUtils.toTreeSet());
        TreeSet completes = (TreeSet)UniLists.of((Object)1, (Object)2, (Object)3, (Object)5, (Object)9).stream().map(x -> (long)x).collect(JavaUtils.toTreeSet());
        OffsetSimultaneousEncoder offsetSimultaneousEncoder = new OffsetSimultaneousEncoder(-1L, 0L, (SortedSet)incompletes);
        int length = 11;
        BitSetEncoder bs = new BitSetEncoder((long)length, offsetSimultaneousEncoder, OffsetEncoding.Version.v2);
        bs.encodeIncompleteOffset(0L);
        bs.encodeCompletedOffset(1L);
        bs.encodeCompletedOffset(2L);
        bs.encodeCompletedOffset(3L);
        bs.encodeIncompleteOffset(4L);
        bs.encodeCompletedOffset(5L);
        bs.encodeIncompleteOffset(6L);
        bs.encodeIncompleteOffset(7L);
        bs.encodeIncompleteOffset(8L);
        bs.encodeCompletedOffset(9L);
        bs.encodeIncompleteOffset(10L);
        Assertions.assertThat((int[])bs.getBitSet().stream().toArray()).containsExactly(new int[]{1, 2, 3, 5, 9});
        byte[] raw = bs.serialise();
        byte[] wrapped = offsetSimultaneousEncoder.packEncoding(new EncodedOffsetPair(OffsetEncoding.BitSetV2, ByteBuffer.wrap(raw)));
        OffsetMapCodecManager.HighestOffsetAndIncompletes result = OffsetMapCodecManager.decodeCompressedOffsets((long)0L, (byte[])wrapped);
        Assertions.assertThat((Optional)result.getHighestSeenOffset()).contains((Object)10L);
        Assertions.assertThat((Collection)result.getIncompleteOffsets()).containsExactlyInAnyOrderElementsOf((Iterable)incompletes);
    }
}

