/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import io.confluent.csid.utils.Range;
import io.confluent.parallelconsumer.state.PartitionState;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetCodecTestUtils {
    private static final Logger log = LoggerFactory.getLogger(OffsetCodecTestUtils.class);

    static String incompletesToBitmapString(long finalOffsetForPartition, long highestSeen, Set<Long> incompletes) {
        StringBuilder runLengthString = new StringBuilder();
        Long lowWaterMark = finalOffsetForPartition;
        long end = highestSeen - lowWaterMark;
        for (Long relativeOffset : Range.range((long)end)) {
            long offset = lowWaterMark + relativeOffset;
            if (incompletes.contains(offset)) {
                runLengthString.append("o");
                continue;
            }
            runLengthString.append("x");
        }
        return runLengthString.toString();
    }

    static String incompletesToBitmapString(long finalOffsetForPartition, PartitionState<?, ?> state) {
        return OffsetCodecTestUtils.incompletesToBitmapString(finalOffsetForPartition, state.getOffsetHighestSeen(), state.getIncompleteOffsetsBelowHighestSucceeded());
    }

    static TreeSet<Long> bitmapStringToIncomplete(long baseOffset, String inputBitmapString) {
        TreeSet<Long> incompleteOffsets = new TreeSet<Long>();
        long longLength = inputBitmapString.length();
        Range.range((long)longLength).forEach(index -> {
            char bit = inputBitmapString.charAt(Math.toIntExact(index));
            if (bit == 'o') {
                incompleteOffsets.add(baseOffset + index);
            } else if (bit == 'x') {
                log.trace("Dropping completed offset");
            } else {
                throw new IllegalArgumentException("Invalid encoding - unexpected char: " + bit);
            }
        });
        return incompleteOffsets;
    }

    private OffsetCodecTestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

