/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.offsets;

import com.google.common.truth.Truth;
import io.confluent.csid.utils.JavaUtils;
import io.confluent.csid.utils.Range;
import io.confluent.parallelconsumer.offsets.EncodedOffsetPair;
import io.confluent.parallelconsumer.offsets.EncodingNotSupportedException;
import io.confluent.parallelconsumer.offsets.OffsetEncoding;
import io.confluent.parallelconsumer.offsets.OffsetMapCodecManager;
import io.confluent.parallelconsumer.offsets.OffsetSimultaneousEncoder;
import io.confluent.parallelconsumer.offsets.RunLengthEncoder;
import io.confluent.parallelconsumer.offsets.RunLengthV1EncodingNotSupported;
import io.confluent.parallelconsumer.offsets.RunLengthV2EncodingNotSupported;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeKind;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import pl.tlinkowski.unij.api.UniLists;
import pl.tlinkowski.unij.api.UniSets;

class RunLengthEncoderTest {
    RunLengthEncoderTest() {
    }

    @Test
    void noGaps() {
        TreeSet incompletes = (TreeSet)UniSets.of((Object)0, (Object)4, (Object)6, (Object)7, (Object)8, (Object)10).stream().map(x -> (long)x).collect(JavaUtils.toTreeSet());
        TreeSet completes = (TreeSet)UniSets.of((Object)1, (Object)2, (Object)3, (Object)5, (Object)9).stream().map(x -> (long)x).collect(JavaUtils.toTreeSet());
        List runs = UniLists.of((Object)1, (Object)3, (Object)1, (Object)1, (Object)3, (Object)1, (Object)1);
        OffsetSimultaneousEncoder offsetSimultaneousEncoder = new OffsetSimultaneousEncoder(-1L, 0L, (SortedSet)incompletes);
        RunLengthEncoder rl = new RunLengthEncoder(offsetSimultaneousEncoder, OffsetEncoding.Version.v2);
        rl.encodeIncompleteOffset(0L);
        rl.encodeCompletedOffset(1L);
        rl.encodeCompletedOffset(2L);
        rl.encodeCompletedOffset(3L);
        rl.encodeIncompleteOffset(4L);
        rl.encodeCompletedOffset(5L);
        rl.encodeIncompleteOffset(6L);
        rl.encodeIncompleteOffset(7L);
        rl.encodeIncompleteOffset(8L);
        rl.encodeCompletedOffset(9L);
        rl.encodeIncompleteOffset(10L);
        rl.addTail();
        Assertions.assertThat((List)rl.getRunLengthEncodingIntegers()).containsExactlyElementsOf((Iterable)runs);
        List calculatedCompletedOffsets = rl.calculateSucceededActualOffsets(0L);
        Assertions.assertThat((List)calculatedCompletedOffsets).containsExactlyElementsOf((Iterable)completes);
    }

    @Test
    void noGapsSerialisation() {
        TreeSet incompletes = (TreeSet)UniSets.of((Object)0, (Object)4, (Object)6, (Object)7, (Object)8, (Object)10).stream().map(x -> (long)x).collect(JavaUtils.toTreeSet());
        TreeSet completes = (TreeSet)UniSets.of((Object)1, (Object)2, (Object)3, (Object)5, (Object)9).stream().map(x -> (long)x).collect(JavaUtils.toTreeSet());
        List runs = UniLists.of((Object)1, (Object)3, (Object)1, (Object)1, (Object)3, (Object)1, (Object)1);
        OffsetSimultaneousEncoder offsetSimultaneousEncoder = new OffsetSimultaneousEncoder(-1L, 0L, (SortedSet)incompletes);
        RunLengthEncoder rl = new RunLengthEncoder(offsetSimultaneousEncoder, OffsetEncoding.Version.v2);
        rl.encodeIncompleteOffset(0L);
        rl.encodeCompletedOffset(1L);
        rl.encodeCompletedOffset(2L);
        rl.encodeCompletedOffset(3L);
        rl.encodeIncompleteOffset(4L);
        rl.encodeCompletedOffset(5L);
        rl.encodeIncompleteOffset(6L);
        rl.encodeIncompleteOffset(7L);
        rl.encodeIncompleteOffset(8L);
        rl.encodeCompletedOffset(9L);
        rl.encodeIncompleteOffset(10L);
        byte[] raw = rl.serialise();
        byte[] wrapped = offsetSimultaneousEncoder.packEncoding(new EncodedOffsetPair(OffsetEncoding.RunLengthV2, ByteBuffer.wrap(raw)));
        OffsetMapCodecManager.HighestOffsetAndIncompletes result = OffsetMapCodecManager.decodeCompressedOffsets((long)0L, (byte[])wrapped);
        Assertions.assertThat((Optional)result.getHighestSeenOffset()).contains((Object)10L);
        Assertions.assertThat((Collection)result.getIncompleteOffsets()).containsExactlyElementsOf((Iterable)incompletes);
    }

    @Test
    void gapsInOffsetsWork() {
        TreeSet incompletes = (TreeSet)UniSets.of((Object)0, (Object)6, (Object)10).stream().map(x -> (long)x).collect(JavaUtils.toTreeSet());
        Set completes = UniSets.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)9).stream().map(x -> (long)x).collect(Collectors.toSet());
        List runs = UniLists.of((Object)1, (Object)5, (Object)3, (Object)1, (Object)1);
        OffsetSimultaneousEncoder offsetSimultaneousEncoder = new OffsetSimultaneousEncoder(-1L, 0L, (SortedSet)incompletes);
        RunLengthEncoder rl = new RunLengthEncoder(offsetSimultaneousEncoder, OffsetEncoding.Version.v2);
        rl.encodeIncompleteOffset(0L);
        rl.encodeCompletedOffset(1L);
        rl.encodeCompletedOffset(3L);
        rl.encodeCompletedOffset(4L);
        rl.encodeCompletedOffset(5L);
        rl.encodeIncompleteOffset(6L);
        rl.encodeIncompleteOffset(8L);
        rl.encodeCompletedOffset(9L);
        rl.encodeIncompleteOffset(10L);
        rl.addTail();
        Assertions.assertThat((List)rl.getRunLengthEncodingIntegers()).containsExactlyElementsOf((Iterable)runs);
        List calculatedCompletedOffsets = rl.calculateSucceededActualOffsets(0L);
        Assertions.assertThat((List)calculatedCompletedOffsets).containsExactlyElementsOf(completes);
    }

    @ParameterizedTest
    @EnumSource(value=OffsetEncoding.Version.class)
    void vTwoIntegerOverflow(OffsetEncoding.Version versionToTest) {
        long integerMaxOverflowOffset = 100L;
        long overflowedValue = 2147483747L;
        TreeSet incompletes = (TreeSet)UniSets.of((Object)0L, (Object)4L, (Object)6L, (Object)7L, (Object)8L, (Object)10L, (Object)2147483747L).stream().collect(JavaUtils.toTreeSet());
        TreeSet completes = (TreeSet)UniSets.of((Object)1, (Object)2, (Object)3, (Object)5, (Object)9).stream().map(x -> (long)x).collect(JavaUtils.toTreeSet());
        OffsetSimultaneousEncoder offsetSimultaneousEncoder = new OffsetSimultaneousEncoder(-1L, 2147483746L, (SortedSet)incompletes);
        OffsetEncoding.Version versionsToTest = OffsetEncoding.Version.v2;
        RunLengthEncoderTest.testRunLength(2147483747L, offsetSimultaneousEncoder, versionToTest);
    }

    private static void testRunLength(long overflowedValue, OffsetSimultaneousEncoder offsetSimultaneousEncoder, OffsetEncoding.Version versionsToTest) throws EncodingNotSupportedException {
        RunLengthEncoder rl = new RunLengthEncoder(offsetSimultaneousEncoder, versionsToTest);
        rl.encodeIncompleteOffset(0L);
        rl.encodeCompletedOffset(1L);
        rl.encodeCompletedOffset(2L);
        rl.encodeCompletedOffset(3L);
        rl.encodeIncompleteOffset(4L);
        rl.encodeCompletedOffset(5L);
        rl.encodeIncompleteOffset(6L);
        rl.encodeIncompleteOffset(7L);
        rl.encodeIncompleteOffset(8L);
        rl.encodeCompletedOffset(9L);
        rl.encodeIncompleteOffset(10L);
        AbstractThrowableAssert errorAssertion = Assertions.assertThatThrownBy(() -> {
            for (Long relativeOffset : Range.range((int)11, (long)overflowedValue)) {
                rl.encodeCompletedOffset(relativeOffset.longValue());
            }
        });
        switch (versionsToTest) {
            case v1: {
                errorAssertion.isInstanceOf(RunLengthV1EncodingNotSupported.class);
                errorAssertion.hasMessageContainingAll(new CharSequence[]{"too big", "Short"});
                break;
            }
            case v2: {
                errorAssertion.isInstanceOf(RunLengthV2EncodingNotSupported.class);
                errorAssertion.hasMessageContainingAll(new CharSequence[]{"too big", "Integer"});
            }
        }
    }

    @ParameterizedTest
    @EnumSource(names={"SHORT", "INT"}, mode=EnumSource.Mode.INCLUDE)
    void testSimultaneousWithOverflowErrors(TypeKind primitiveSize) {
        int n;
        Assumptions.assumeTrue((primitiveSize == TypeKind.SHORT || primitiveSize == TypeKind.INT ? 1 : 0) != 0);
        long integerMaxOverflowOffset = 100L;
        switch (primitiveSize) {
            case SHORT: {
                n = Short.MAX_VALUE;
                break;
            }
            case INT: {
                n = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)primitiveSize));
            }
        }
        int maxValue = n;
        long overflowedValue = (long)maxValue + 100L;
        TreeSet incompletes = (TreeSet)UniSets.of((Object)0L, (Object)4L, (Object)6L, (Object)7L, (Object)8L, (Object)10L, (Object)overflowedValue).stream().collect(JavaUtils.toTreeSet());
        TreeSet completes = (TreeSet)UniSets.of((Object)1, (Object)2, (Object)3, (Object)5, (Object)9).stream().map(x -> (long)x).collect(JavaUtils.toTreeSet());
        OffsetSimultaneousEncoder offsetSimultaneousEncoder = new OffsetSimultaneousEncoder(-1L, overflowedValue - 1L, (SortedSet)incompletes);
        offsetSimultaneousEncoder.invoke();
        Map encodingMap = offsetSimultaneousEncoder.getEncodingMap();
        switch (primitiveSize) {
            case SHORT: {
                Truth.assertThat((Map)encodingMap).hasSize(2);
                break;
            }
            case INT: {
                Truth.assertThat((Map)encodingMap).hasSize(0);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)primitiveSize));
            }
        }
    }
}

