/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.sanity;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTest {
    private static final Logger log = LoggerFactory.getLogger(StreamTest.class);

    public void test() {
        Stream<Double> s = Stream.generate(() -> Math.random());
        s.forEach(x -> log.info(x.toString()));
    }

    @Test
    public void testStreamSpliterators() {
        final int max = 10;
        Iterator<String> i = new Iterator<String>(){
            int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < max;
            }

            @Override
            public String next() {
                ++this.count;
                return this.count + " " + Math.random();
            }
        };
        Spliterator<String> spliterator = Spliterators.spliterator(i, 0L, 256);
        Stream<String> stream = StreamSupport.stream(spliterator, false);
        List collect = stream.map(x -> {
            log.info(x);
            return x.toUpperCase();
        }).collect(Collectors.toList());
        Assertions.assertThat(collect).hasSize(max);
    }
}

