/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.LongSubject;
import com.google.common.truth.Subject;
import io.confluent.parallelconsumer.state.ConsumerRecordId;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionSubject;

public class ConsumerRecordIdParentSubject
extends Subject {
    protected final ConsumerRecordId actual;

    protected ConsumerRecordIdParentSubject(FailureMetadata failureMetadata, ConsumerRecordId actual) {
        super(failureMetadata, (Object)actual);
        this.actual = actual;
    }

    public LongSubject getOffset() {
        this.isNotNull();
        return this.check("getOffset()", new Object[0]).that(Long.valueOf(this.actual.getOffset()));
    }

    public void hasOffsetNotEqualTo(long expected) {
        if (this.actual.getOffset() == expected) {
            this.failWithActual(Fact.fact((String)"expected Offset NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasOffsetEqualTo(long expected) {
        if (this.actual.getOffset() != expected) {
            this.failWithActual(Fact.fact((String)"expected Offset to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public TopicPartitionSubject getTp() {
        this.isNotNull();
        return (TopicPartitionSubject)this.check("getTp()", new Object[0]).about(TopicPartitionSubject.topicPartitions()).that((Object)this.actual.getTp());
    }

    public void hasTpNotEqualTo(TopicPartition expected) {
        if (this.actual.getTp().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected Tp NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasTpEqualTo(TopicPartition expected) {
        if (!this.actual.getTp().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected Tp to be equal to", (Object)expected), new Fact[0]);
        }
    }
}

