/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.parallelconsumer.internal.EpochAndRecordsMap;
import io.confluent.parallelconsumer.internal.PCModule;
import io.confluent.parallelconsumer.internal.PCModuleTestEnv;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.mockito.Mockito;
import pl.tlinkowski.unij.api.UniLists;
import pl.tlinkowski.unij.api.UniMaps;

public class ModelUtils {
    private final PCModuleTestEnv module;
    final String topic = "topic";
    private long nextOffset = 0L;
    final String groupId = "cg-1";

    public ModelUtils() {
        this(new PCModuleTestEnv());
    }

    public WorkContainer<String, String> createWorkFor(long offset) {
        ConsumerRecord mockCr = (ConsumerRecord)Mockito.mock(ConsumerRecord.class);
        WorkContainer workContainer = new WorkContainer(0L, mockCr, (PCModule)this.module);
        ((ConsumerRecord)Mockito.doReturn((Object)offset).when((Object)mockCr)).offset();
        return workContainer;
    }

    public EpochAndRecordsMap<String, String> createFreshWork() {
        return new EpochAndRecordsMap(this.createConsumerRecords(), this.module.workManager().getPm());
    }

    public ConsumerRecords<String, String> createConsumerRecords() {
        return new ConsumerRecords(UniMaps.of((Object)this.getPartition(), (Object)UniLists.of(this.createConsumerRecord("topic"))));
    }

    @NonNull
    public TopicPartition getPartition() {
        return new TopicPartition("topic", 0);
    }

    @NonNull
    public List<TopicPartition> getPartitions() {
        return UniLists.of((Object)new TopicPartition("topic", 0));
    }

    @NonNull
    private ConsumerRecord<String, String> createConsumerRecord(String topic) {
        ConsumerRecord cr = new ConsumerRecord(topic, 0, this.nextOffset, (Object)"a-key", (Object)"a-value");
        ++this.nextOffset;
        return cr;
    }

    public ProducerRecord<String, String> createProducerRecords() {
        return new ProducerRecord("topic", (Object)"a-key", (Object)"a-value");
    }

    public ConsumerGroupMetadata consumerGroupMeta() {
        return new ConsumerGroupMetadata("cg-1");
    }

    public List<ProducerRecord<String, String>> createProducerRecords(String topicName, long numberToSend) {
        return this.createProducerRecords(topicName, numberToSend, "");
    }

    public List<ProducerRecord<String, String>> createProducerRecords(String topicName, long numberToSend, String prefix) {
        ArrayList<ProducerRecord<String, String>> recs = new ArrayList<ProducerRecord<String, String>>();
        int i = 0;
        while ((long)i < numberToSend) {
            String key = prefix + "key-" + i;
            ProducerRecord record = new ProducerRecord(topicName, (Object)key, (Object)("value-" + i));
            recs.add((ProducerRecord<String, String>)record);
            ++i;
        }
        return recs;
    }

    public ModelUtils(PCModuleTestEnv module) {
        this.module = module;
    }

    public PCModuleTestEnv getModule() {
        return this.module;
    }

    public String getTopic() {
        return this.topic;
    }
}

