/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.Subject;
import io.confluent.parallelconsumer.state.PartitionState;
import io.stubbs.truth.generator.subjects.MyCollectionSubject;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadataSubject;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionSubject;

public class PartitionStateParentSubject
extends Subject {
    protected final PartitionState actual;

    protected PartitionStateParentSubject(FailureMetadata failureMetadata, PartitionState actual) {
        super(failureMetadata, (Object)actual);
        this.actual = actual;
    }

    public MyCollectionSubject getAllIncompleteOffsets() {
        this.isNotNull();
        return (MyCollectionSubject)this.check("getAllIncompleteOffsets()", new Object[0]).about(MyCollectionSubject.collections()).that((Object)this.actual.getAllIncompleteOffsets());
    }

    public void hasAllIncompleteOffsetsNotWithElement(Long expected) {
        if (!this.actual.getAllIncompleteOffsets().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected AllIncompleteOffsets NOT to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasAllIncompleteOffsetsWithElement(Long expected) {
        if (this.actual.getAllIncompleteOffsets().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected AllIncompleteOffsets to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasAllIncompleteOffsetsNotEqualTo(List expected) {
        if (this.actual.getAllIncompleteOffsets().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected AllIncompleteOffsets NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasAllIncompleteOffsetsEqualTo(List expected) {
        if (!this.actual.getAllIncompleteOffsets().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected AllIncompleteOffsets to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public OffsetAndMetadataSubject getCommitDataIfDirty() {
        this.isNotNull();
        this.hasCommitDataIfDirtyPresent();
        return (OffsetAndMetadataSubject)this.check("getCommitDataIfDirty().get()", new Object[0]).about(OffsetAndMetadataSubject.offsetAndMetadatas()).that((Object)((OffsetAndMetadata)this.actual.getCommitDataIfDirty().get()));
    }

    public void hasCommitDataIfDirtyNotPresent() {
        if (this.actual.getCommitDataIfDirty().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected CommitDataIfDirty NOT to be present"), new Fact[0]);
        }
    }

    public void hasCommitDataIfDirtyPresent() {
        if (!this.actual.getCommitDataIfDirty().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected CommitDataIfDirty to be present"), new Fact[0]);
        }
    }

    public void hasCommitDataIfDirtyNotEqualTo(Optional expected) {
        if (this.actual.getCommitDataIfDirty().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected CommitDataIfDirty NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasCommitDataIfDirtyEqualTo(Optional expected) {
        if (!this.actual.getCommitDataIfDirty().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected CommitDataIfDirty to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public MyCollectionSubject getIncompleteOffsetsBelowHighestSucceeded() {
        this.isNotNull();
        return (MyCollectionSubject)this.check("getIncompleteOffsetsBelowHighestSucceeded()", new Object[0]).about(MyCollectionSubject.collections()).that((Object)this.actual.getIncompleteOffsetsBelowHighestSucceeded());
    }

    public void hasIncompleteOffsetsBelowHighestSucceededNotWithElement(Long expected) {
        if (!this.actual.getIncompleteOffsetsBelowHighestSucceeded().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected IncompleteOffsetsBelowHighestSucceeded NOT to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasIncompleteOffsetsBelowHighestSucceededWithElement(Long expected) {
        if (this.actual.getIncompleteOffsetsBelowHighestSucceeded().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected IncompleteOffsetsBelowHighestSucceeded to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasIncompleteOffsetsBelowHighestSucceededNotEqualTo(SortedSet expected) {
        if (this.actual.getIncompleteOffsetsBelowHighestSucceeded().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected IncompleteOffsetsBelowHighestSucceeded NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasIncompleteOffsetsBelowHighestSucceededEqualTo(SortedSet expected) {
        if (!this.actual.getIncompleteOffsetsBelowHighestSucceeded().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected IncompleteOffsetsBelowHighestSucceeded to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IntegerSubject getNumberOfIncompleteOffsets() {
        this.isNotNull();
        return this.check("getNumberOfIncompleteOffsets()", new Object[0]).that(Integer.valueOf(this.actual.getNumberOfIncompleteOffsets()));
    }

    public void hasNumberOfIncompleteOffsetsNotEqualTo(int expected) {
        if (this.actual.getNumberOfIncompleteOffsets() == expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfIncompleteOffsets NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasNumberOfIncompleteOffsetsEqualTo(int expected) {
        if (this.actual.getNumberOfIncompleteOffsets() != expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfIncompleteOffsets to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public LongSubject getOffsetHighestSeen() {
        this.isNotNull();
        return this.check("getOffsetHighestSeen()", new Object[0]).that(Long.valueOf(this.actual.getOffsetHighestSeen()));
    }

    public void hasOffsetHighestSeenNotEqualTo(long expected) {
        if (this.actual.getOffsetHighestSeen() == expected) {
            this.failWithActual(Fact.fact((String)"expected OffsetHighestSeen NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasOffsetHighestSeenEqualTo(long expected) {
        if (this.actual.getOffsetHighestSeen() != expected) {
            this.failWithActual(Fact.fact((String)"expected OffsetHighestSeen to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public LongSubject getOffsetHighestSequentialSucceeded() {
        this.isNotNull();
        return this.check("getOffsetHighestSequentialSucceeded()", new Object[0]).that(Long.valueOf(this.actual.getOffsetHighestSequentialSucceeded()));
    }

    public void hasOffsetHighestSequentialSucceededNotEqualTo(long expected) {
        if (this.actual.getOffsetHighestSequentialSucceeded() == expected) {
            this.failWithActual(Fact.fact((String)"expected OffsetHighestSequentialSucceeded NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasOffsetHighestSequentialSucceededEqualTo(long expected) {
        if (this.actual.getOffsetHighestSequentialSucceeded() != expected) {
            this.failWithActual(Fact.fact((String)"expected OffsetHighestSequentialSucceeded to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public LongSubject getOffsetHighestSucceeded() {
        this.isNotNull();
        return this.check("getOffsetHighestSucceeded()", new Object[0]).that(Long.valueOf(this.actual.getOffsetHighestSucceeded()));
    }

    public void hasOffsetHighestSucceededNotEqualTo(long expected) {
        if (this.actual.getOffsetHighestSucceeded() == expected) {
            this.failWithActual(Fact.fact((String)"expected OffsetHighestSucceeded NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasOffsetHighestSucceededEqualTo(long expected) {
        if (this.actual.getOffsetHighestSucceeded() != expected) {
            this.failWithActual(Fact.fact((String)"expected OffsetHighestSucceeded to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public LongSubject getPartitionsAssignmentEpoch() {
        this.isNotNull();
        return this.check("getPartitionsAssignmentEpoch()", new Object[0]).that(Long.valueOf(this.actual.getPartitionsAssignmentEpoch()));
    }

    public void hasPartitionsAssignmentEpochNotEqualTo(long expected) {
        if (this.actual.getPartitionsAssignmentEpoch() == expected) {
            this.failWithActual(Fact.fact((String)"expected PartitionsAssignmentEpoch NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasPartitionsAssignmentEpochEqualTo(long expected) {
        if (this.actual.getPartitionsAssignmentEpoch() != expected) {
            this.failWithActual(Fact.fact((String)"expected PartitionsAssignmentEpoch to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public TopicPartitionSubject getTp() {
        this.isNotNull();
        return (TopicPartitionSubject)this.check("getTp()", new Object[0]).about(TopicPartitionSubject.topicPartitions()).that((Object)this.actual.getTp());
    }

    public void hasTpNotEqualTo(TopicPartition expected) {
        if (this.actual.getTp().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected Tp NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasTpEqualTo(TopicPartition expected) {
        if (!this.actual.getTp().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected Tp to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void isAllowedMoreRecords() {
        if (!this.actual.isAllowedMoreRecords()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'allowed more records' (`isAllowedMoreRecords`)"), new Fact[0]);
        }
    }

    public void isNotAllowedMoreRecords() {
        if (this.actual.isAllowedMoreRecords()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'allowed more records' (`isAllowedMoreRecords`)"), new Fact[0]);
        }
    }

    public void isBlocked() {
        if (!this.actual.isBlocked()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'blocked' (`isBlocked`)"), new Fact[0]);
        }
    }

    public void isNotBlocked() {
        if (this.actual.isBlocked()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'blocked' (`isBlocked`)"), new Fact[0]);
        }
    }

    public void isDirty() {
        if (!this.actual.isDirty()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'dirty' (`isDirty`)"), new Fact[0]);
        }
    }

    public void isNotDirty() {
        if (this.actual.isDirty()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'dirty' (`isDirty`)"), new Fact[0]);
        }
    }

    public void isPartitionRemovedOrNeverAssigned() {
        if (!this.actual.isPartitionRemovedOrNeverAssigned()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'partition removed or never assigned' (`isPartitionRemovedOrNeverAssigned`)"), new Fact[0]);
        }
    }

    public void isNotPartitionRemovedOrNeverAssigned() {
        if (this.actual.isPartitionRemovedOrNeverAssigned()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'partition removed or never assigned' (`isPartitionRemovedOrNeverAssigned`)"), new Fact[0]);
        }
    }

    public void isRemoved() {
        if (!this.actual.isRemoved()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'removed' (`isRemoved`)"), new Fact[0]);
        }
    }

    public void isNotRemoved() {
        if (this.actual.isRemoved()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'removed' (`isRemoved`)"), new Fact[0]);
        }
    }
}

