/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.parallelconsumer.internal.EpochAndRecordsMap;
import io.confluent.parallelconsumer.state.ModelUtils;
import io.confluent.parallelconsumer.state.PartitionStateManager;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.mockito.Mockito;
import pl.tlinkowski.unij.api.UniMaps;

public class PolledTestBatch {
    final ModelUtils mu;
    private final TopicPartition tp;
    List<WorkContainer<String, String>> polledBatchWCs;
    List<ConsumerRecord<String, String>> polledBatch;
    EpochAndRecordsMap<String, String> polledRecordBatch;

    public PolledTestBatch(ModelUtils mu, TopicPartition tp, long fromOffset, long toOffset) {
        this.mu = mu;
        this.tp = tp;
        this.create(fromOffset, toOffset);
    }

    public PolledTestBatch(ModelUtils mu, TopicPartition tp, List<Long> polledOffsetsWithCompactedRemoved) {
        this.mu = mu;
        this.tp = tp;
        this.create(polledOffsetsWithCompactedRemoved);
    }

    void create(long fromOffset, long highestSeenOffset) {
        List offsets = LongStreamEx.range((long)fromOffset, (long)(highestSeenOffset + 1L)).boxed().toList();
        this.create(offsets);
    }

    void create(List<Long> offsets) {
        StreamEx offsetStream = StreamEx.of(offsets);
        this.polledBatchWCs = offsetStream.map(this.mu::createWorkFor).toList();
        this.polledBatch = this.polledBatchWCs.stream().map(WorkContainer::getCr).collect(Collectors.toList());
        ConsumerRecords consumerRecords = new ConsumerRecords(UniMaps.of((Object)this.tp, this.polledBatch));
        PartitionStateManager mock = (PartitionStateManager)Mockito.mock(PartitionStateManager.class);
        Mockito.when((Object)mock.getEpochOfPartition(this.tp)).thenReturn((Object)0L);
        this.polledRecordBatch = new EpochAndRecordsMap(consumerRecords, mock);
    }
}

