/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.parallelconsumer.ManagedTruth;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.state.ShardKey;
import io.confluent.parallelconsumer.state.WorkContainer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ShardKeyTest {
    ShardKeyTest() {
    }

    @Test
    void nullKey() {
        ConsumerRecord cr = (ConsumerRecord)Mockito.mock(ConsumerRecord.class);
        Mockito.when((Object)cr.partition()).thenReturn((Object)0);
        Mockito.when((Object)cr.topic()).thenReturn((Object)"atopic");
        Mockito.when((Object)cr.key()).thenReturn(null);
        WorkContainer wc = (WorkContainer)Mockito.mock(WorkContainer.class);
        Mockito.when((Object)wc.getCr()).thenReturn((Object)cr);
        ShardKey.of((WorkContainer)wc, (ParallelConsumerOptions.ProcessingOrder)ParallelConsumerOptions.ProcessingOrder.KEY);
    }

    @Test
    void keyTest() {
        ParallelConsumerOptions.ProcessingOrder ordering = ParallelConsumerOptions.ProcessingOrder.KEY;
        String topicOne = "t1";
        TopicPartition topicOneP0 = new TopicPartition("t1", 0);
        String keyOne = "k1";
        ConsumerRecord reck1 = new ConsumerRecord(topicOne, 0, 0L, (Object)keyOne, (Object)"v");
        ShardKey key1 = ShardKey.of((ConsumerRecord)reck1, (ParallelConsumerOptions.ProcessingOrder)ordering);
        ShardKey anotherInstanceWithSameInputs = ShardKey.of((ConsumerRecord)reck1, (ParallelConsumerOptions.ProcessingOrder)ordering);
        ManagedTruth.assertThat(key1).isEqualTo(anotherInstanceWithSameInputs);
        ConsumerRecord reck2 = new ConsumerRecord(topicOne, 0, 0L, (Object)"k2", (Object)"v");
        ShardKey of3 = ShardKey.of((ConsumerRecord)reck2, (ParallelConsumerOptions.ProcessingOrder)ordering);
        ManagedTruth.assertThat(key1).isNotEqualTo(of3);
        ConsumerRecord reck3 = new ConsumerRecord("t2", 0, 0L, (Object)keyOne, (Object)"v");
        ManagedTruth.assertThat(key1).isNotEqualTo(ShardKey.of((ConsumerRecord)reck3, (ParallelConsumerOptions.ProcessingOrder)ordering));
        ShardKey.KeyOrderedKey keyOrderedKey = new ShardKey.KeyOrderedKey(topicOneP0, (Object)keyOne);
        ShardKey.KeyOrderedKey keyOrderedKeyTwo = new ShardKey.KeyOrderedKey(topicOneP0, (Object)keyOne);
        ManagedTruth.assertThat((ShardKey)keyOrderedKey).isEqualTo(keyOrderedKeyTwo);
        ConsumerRecord reck4 = new ConsumerRecord(topicOne, 1, 0L, (Object)keyOne, (Object)"v");
        ShardKey of4 = ShardKey.of((ConsumerRecord)reck2, (ParallelConsumerOptions.ProcessingOrder)ordering);
        ManagedTruth.assertThat(key1).isNotEqualTo(of3);
    }
}

