/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.LongSubject;
import com.google.common.truth.Subject;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.ParallelConsumerOptionsSubject;
import io.confluent.parallelconsumer.autoShaded.java.time.DurationSubject;
import io.confluent.parallelconsumer.autoShaded.java.util.ComparatorSubject;
import io.confluent.parallelconsumer.state.ShardManager;
import io.confluent.parallelconsumer.state.WorkContainer;
import io.stubbs.truth.generator.subjects.MyCollectionSubject;
import java.time.Duration;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Optional;

public class ShardManagerParentSubject
extends Subject {
    protected final ShardManager actual;

    protected ShardManagerParentSubject(FailureMetadata failureMetadata, ShardManager actual) {
        super(failureMetadata, (Object)actual);
        this.actual = actual;
    }

    public DurationSubject getLowestRetryTime() {
        this.isNotNull();
        this.hasLowestRetryTimePresent();
        return (DurationSubject)this.check("getLowestRetryTime().get()", new Object[0]).about(DurationSubject.durations()).that((Object)((Duration)this.actual.getLowestRetryTime().get()));
    }

    public void hasLowestRetryTimeNotPresent() {
        if (this.actual.getLowestRetryTime().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected LowestRetryTime NOT to be present"), new Fact[0]);
        }
    }

    public void hasLowestRetryTimePresent() {
        if (!this.actual.getLowestRetryTime().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected LowestRetryTime to be present"), new Fact[0]);
        }
    }

    public void hasLowestRetryTimeNotEqualTo(Optional expected) {
        if (this.actual.getLowestRetryTime().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected LowestRetryTime NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasLowestRetryTimeEqualTo(Optional expected) {
        if (!this.actual.getLowestRetryTime().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected LowestRetryTime to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public LongSubject getNumberOfWorkQueuedInShardsAwaitingSelection() {
        this.isNotNull();
        return this.check("getNumberOfWorkQueuedInShardsAwaitingSelection()", new Object[0]).that(Long.valueOf(this.actual.getNumberOfWorkQueuedInShardsAwaitingSelection()));
    }

    public void hasNumberOfWorkQueuedInShardsAwaitingSelectionNotEqualTo(long expected) {
        if (this.actual.getNumberOfWorkQueuedInShardsAwaitingSelection() == expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfWorkQueuedInShardsAwaitingSelection NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasNumberOfWorkQueuedInShardsAwaitingSelectionEqualTo(long expected) {
        if (this.actual.getNumberOfWorkQueuedInShardsAwaitingSelection() != expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfWorkQueuedInShardsAwaitingSelection to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public ParallelConsumerOptionsSubject getOptions() {
        this.isNotNull();
        return (ParallelConsumerOptionsSubject)this.check("getOptions()", new Object[0]).about(ParallelConsumerOptionsSubject.parallelConsumerOptionses()).that((Object)this.actual.getOptions());
    }

    public void hasOptionsNotEqualTo(ParallelConsumerOptions expected) {
        if (this.actual.getOptions().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Options NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasOptionsEqualTo(ParallelConsumerOptions expected) {
        if (!this.actual.getOptions().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Options to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public MyCollectionSubject getRetryQueue() {
        this.isNotNull();
        return (MyCollectionSubject)this.check("getRetryQueue()", new Object[0]).about(MyCollectionSubject.collections()).that((Object)this.actual.getRetryQueue());
    }

    public void hasRetryQueueNotWithElement(WorkContainer expected) {
        if (!this.actual.getRetryQueue().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryQueue NOT to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasRetryQueueWithElement(WorkContainer expected) {
        if (this.actual.getRetryQueue().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryQueue to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasRetryQueueNotEqualTo(NavigableSet expected) {
        if (this.actual.getRetryQueue().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryQueue NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasRetryQueueEqualTo(NavigableSet expected) {
        if (!this.actual.getRetryQueue().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryQueue to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public ComparatorSubject getRetryQueueWorkContainerComparator() {
        this.isNotNull();
        return (ComparatorSubject)this.check("getRetryQueueWorkContainerComparator()", new Object[0]).about(ComparatorSubject.comparators()).that((Object)this.actual.getRetryQueueWorkContainerComparator());
    }

    public void hasRetryQueueWorkContainerComparatorNotEqualTo(Comparator expected) {
        if (this.actual.getRetryQueueWorkContainerComparator().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryQueueWorkContainerComparator NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasRetryQueueWorkContainerComparatorEqualTo(Comparator expected) {
        if (!this.actual.getRetryQueueWorkContainerComparator().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryQueueWorkContainerComparator to be equal to", (Object)expected), new Fact[0]);
        }
    }
}

