/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import com.google.common.truth.Truth;
import io.confluent.parallelconsumer.internal.PCModule;
import io.confluent.parallelconsumer.internal.PCModuleTestEnv;
import io.confluent.parallelconsumer.state.ModelUtils;
import io.confluent.parallelconsumer.state.ShardManager;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.util.NavigableSet;
import org.junit.jupiter.api.Test;
import pl.tlinkowski.unij.api.UniLists;

class ShardManagerTest {
    ModelUtils mu = new ModelUtils();

    ShardManagerTest() {
    }

    @Test
    void retryQueueOrdering() {
        PCModuleTestEnv module = this.mu.getModule();
        ShardManager sm = new ShardManager((PCModule)module, module.workManager());
        NavigableSet retryQueue = sm.getRetryQueue();
        WorkContainer<String, String> w0 = this.mu.createWorkFor(0L);
        WorkContainer<String, String> w1 = this.mu.createWorkFor(1L);
        WorkContainer<String, String> w2 = this.mu.createWorkFor(2L);
        WorkContainer<String, String> w3 = this.mu.createWorkFor(3L);
        boolean ZERO = false;
        Truth.assertThat((Integer)sm.getRetryQueueWorkContainerComparator().compare(w0, w0)).isEqualTo((Object)0);
        retryQueue.add(w0);
        retryQueue.add(w1);
        retryQueue.add(w2);
        retryQueue.add(w3);
        Truth.assertThat((Iterable)retryQueue).hasSize(4);
        Truth.assertThat(w0).isNotEqualTo(w1);
        Truth.assertThat(w1).isNotEqualTo(w2);
        boolean removed = retryQueue.remove(w1);
        Truth.assertThat((Boolean)removed).isTrue();
        Truth.assertThat((Iterable)retryQueue).hasSize(3);
        Truth.assertThat((Iterable)retryQueue).containsNoDuplicates();
        Truth.assertThat((Boolean)retryQueue.contains(w0)).isTrue();
        Truth.assertThat((Boolean)retryQueue.contains(w1)).isFalse();
        Truth.assertThat((Iterable)retryQueue).contains(w0);
        Truth.assertThat((Iterable)retryQueue).containsNoneIn((Iterable)UniLists.of(w1));
        Truth.assertThat((Iterable)retryQueue).contains(w2);
    }
}

