/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.ThrowableSubject;
import io.confluent.parallelconsumer.autoShaded.java.time.DurationSubject;
import io.confluent.parallelconsumer.autoShaded.java.time.InstantSubject;
import io.confluent.parallelconsumer.autoShaded.java.util.concurrent.FutureSubject;
import io.confluent.parallelconsumer.state.WorkContainer;
import io.stubbs.truth.generator.subjects.MyStringSubject;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecordSubject;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionSubject;

public class WorkContainerParentSubject
extends ComparableSubject {
    protected final WorkContainer actual;

    protected WorkContainerParentSubject(FailureMetadata failureMetadata, WorkContainer actual) {
        super(failureMetadata, (Comparable)actual);
        this.actual = actual;
    }

    public ConsumerRecordSubject getCr() {
        this.isNotNull();
        return (ConsumerRecordSubject)this.check("getCr()", new Object[0]).about(ConsumerRecordSubject.consumerRecords()).that((Object)this.actual.getCr());
    }

    public void hasCrNotEqualTo(ConsumerRecord expected) {
        if (this.actual.getCr().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Cr NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasCrEqualTo(ConsumerRecord expected) {
        if (!this.actual.getCr().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Cr to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public DurationSubject getDelayUntilRetryDue() {
        this.isNotNull();
        return (DurationSubject)this.check("getDelayUntilRetryDue()", new Object[0]).about(DurationSubject.durations()).that((Object)this.actual.getDelayUntilRetryDue());
    }

    public void hasDelayUntilRetryDueNotEqualTo(Duration expected) {
        if (this.actual.getDelayUntilRetryDue().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected DelayUntilRetryDue NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasDelayUntilRetryDueEqualTo(Duration expected) {
        if (!this.actual.getDelayUntilRetryDue().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected DelayUntilRetryDue to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public LongSubject getEpoch() {
        this.isNotNull();
        return this.check("getEpoch()", new Object[0]).that(Long.valueOf(this.actual.getEpoch()));
    }

    public void hasEpochNotEqualTo(long expected) {
        if (this.actual.getEpoch() == expected) {
            this.failWithActual(Fact.fact((String)"expected Epoch NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasEpochEqualTo(long expected) {
        if (this.actual.getEpoch() != expected) {
            this.failWithActual(Fact.fact((String)"expected Epoch to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public FutureSubject getFuture() {
        this.isNotNull();
        return (FutureSubject)this.check("getFuture()", new Object[0]).about(FutureSubject.futures()).that((Object)this.actual.getFuture());
    }

    public void hasFutureNotEqualTo(Future expected) {
        if (this.actual.getFuture().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Future NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasFutureEqualTo(Future expected) {
        if (!this.actual.getFuture().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Future to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public InstantSubject getLastFailedAt() {
        this.isNotNull();
        this.hasLastFailedAtPresent();
        return (InstantSubject)this.check("getLastFailedAt().get()", new Object[0]).about(InstantSubject.instants()).that((Object)((Instant)this.actual.getLastFailedAt().get()));
    }

    public void hasLastFailedAtNotPresent() {
        if (this.actual.getLastFailedAt().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected LastFailedAt NOT to be present"), new Fact[0]);
        }
    }

    public void hasLastFailedAtPresent() {
        if (!this.actual.getLastFailedAt().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected LastFailedAt to be present"), new Fact[0]);
        }
    }

    public void hasLastFailedAtNotEqualTo(Optional expected) {
        if (this.actual.getLastFailedAt().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected LastFailedAt NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasLastFailedAtEqualTo(Optional expected) {
        if (!this.actual.getLastFailedAt().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected LastFailedAt to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public ThrowableSubject getLastFailureReason() {
        this.isNotNull();
        this.hasLastFailureReasonPresent();
        return this.check("getLastFailureReason().get()", new Object[0]).that((Throwable)this.actual.getLastFailureReason().get());
    }

    public void hasLastFailureReasonNotPresent() {
        if (this.actual.getLastFailureReason().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected LastFailureReason NOT to be present"), new Fact[0]);
        }
    }

    public void hasLastFailureReasonPresent() {
        if (!this.actual.getLastFailureReason().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected LastFailureReason to be present"), new Fact[0]);
        }
    }

    public void hasLastFailureReasonNotEqualTo(Optional expected) {
        if (this.actual.getLastFailureReason().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected LastFailureReason NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasLastFailureReasonEqualTo(Optional expected) {
        if (!this.actual.getLastFailureReason().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected LastFailureReason to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasMaybeUserFunctionSucceededNotPresent() {
        if (this.actual.getMaybeUserFunctionSucceeded().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected MaybeUserFunctionSucceeded NOT to be present"), new Fact[0]);
        }
    }

    public void hasMaybeUserFunctionSucceededPresent() {
        if (!this.actual.getMaybeUserFunctionSucceeded().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected MaybeUserFunctionSucceeded to be present"), new Fact[0]);
        }
    }

    public void hasMaybeUserFunctionSucceededNotEqualTo(Optional expected) {
        if (this.actual.getMaybeUserFunctionSucceeded().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected MaybeUserFunctionSucceeded NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasMaybeUserFunctionSucceededEqualTo(Optional expected) {
        if (!this.actual.getMaybeUserFunctionSucceeded().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected MaybeUserFunctionSucceeded to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IntegerSubject getNumberOfFailedAttempts() {
        this.isNotNull();
        return this.check("getNumberOfFailedAttempts()", new Object[0]).that(Integer.valueOf(this.actual.getNumberOfFailedAttempts()));
    }

    public void hasNumberOfFailedAttemptsNotEqualTo(int expected) {
        if (this.actual.getNumberOfFailedAttempts() == expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfFailedAttempts NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasNumberOfFailedAttemptsEqualTo(int expected) {
        if (this.actual.getNumberOfFailedAttempts() != expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfFailedAttempts to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public DurationSubject getRetryDelayConfig() {
        this.isNotNull();
        return (DurationSubject)this.check("getRetryDelayConfig()", new Object[0]).about(DurationSubject.durations()).that((Object)this.actual.getRetryDelayConfig());
    }

    public void hasRetryDelayConfigNotEqualTo(Duration expected) {
        if (this.actual.getRetryDelayConfig().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryDelayConfig NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasRetryDelayConfigEqualTo(Duration expected) {
        if (!this.actual.getRetryDelayConfig().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryDelayConfig to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public InstantSubject getRetryDueAt() {
        this.isNotNull();
        return (InstantSubject)this.check("getRetryDueAt()", new Object[0]).about(InstantSubject.instants()).that((Object)this.actual.getRetryDueAt());
    }

    public void hasRetryDueAtNotEqualTo(Instant expected) {
        if (this.actual.getRetryDueAt().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryDueAt NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasRetryDueAtEqualTo(Instant expected) {
        if (!this.actual.getRetryDueAt().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected RetryDueAt to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public InstantSubject getSucceededAt() {
        this.isNotNull();
        this.hasSucceededAtPresent();
        return (InstantSubject)this.check("getSucceededAt().get()", new Object[0]).about(InstantSubject.instants()).that((Object)((Instant)this.actual.getSucceededAt().get()));
    }

    public void hasSucceededAtNotPresent() {
        if (this.actual.getSucceededAt().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected SucceededAt NOT to be present"), new Fact[0]);
        }
    }

    public void hasSucceededAtPresent() {
        if (!this.actual.getSucceededAt().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected SucceededAt to be present"), new Fact[0]);
        }
    }

    public void hasSucceededAtNotEqualTo(Optional expected) {
        if (this.actual.getSucceededAt().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected SucceededAt NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasSucceededAtEqualTo(Optional expected) {
        if (!this.actual.getSucceededAt().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected SucceededAt to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public DurationSubject getTimeInFlight() {
        this.isNotNull();
        return (DurationSubject)this.check("getTimeInFlight()", new Object[0]).about(DurationSubject.durations()).that((Object)this.actual.getTimeInFlight());
    }

    public void hasTimeInFlightNotEqualTo(Duration expected) {
        if (this.actual.getTimeInFlight().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected TimeInFlight NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasTimeInFlightEqualTo(Duration expected) {
        if (!this.actual.getTimeInFlight().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected TimeInFlight to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public TopicPartitionSubject getTopicPartition() {
        this.isNotNull();
        return (TopicPartitionSubject)this.check("getTopicPartition()", new Object[0]).about(TopicPartitionSubject.topicPartitions()).that((Object)this.actual.getTopicPartition());
    }

    public void hasTopicPartitionNotEqualTo(TopicPartition expected) {
        if (this.actual.getTopicPartition().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected TopicPartition NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasTopicPartitionEqualTo(TopicPartition expected) {
        if (!this.actual.getTopicPartition().equals((Object)expected)) {
            this.failWithActual(Fact.fact((String)"expected TopicPartition to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public MyStringSubject getWorkType() {
        this.isNotNull();
        return (MyStringSubject)this.check("getWorkType()", new Object[0]).about(MyStringSubject.strings()).that((Object)this.actual.getWorkType());
    }

    public void hasWorkTypeNotEqualTo(String expected) {
        if (this.actual.getWorkType().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected WorkType NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasWorkTypeEqualTo(String expected) {
        if (!this.actual.getWorkType().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected WorkType to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void isAvailableToTakeAsWork() {
        if (!this.actual.isAvailableToTakeAsWork()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'available to take as work' (`isAvailableToTakeAsWork`)"), new Fact[0]);
        }
    }

    public void isNotAvailableToTakeAsWork() {
        if (this.actual.isAvailableToTakeAsWork()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'available to take as work' (`isAvailableToTakeAsWork`)"), new Fact[0]);
        }
    }

    public void isDelayPassed() {
        if (!this.actual.isDelayPassed()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'delay passed' (`isDelayPassed`)"), new Fact[0]);
        }
    }

    public void isNotDelayPassed() {
        if (this.actual.isDelayPassed()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'delay passed' (`isDelayPassed`)"), new Fact[0]);
        }
    }

    public void isInFlight() {
        if (!this.actual.isInFlight()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'in flight' (`isInFlight`)"), new Fact[0]);
        }
    }

    public void isNotInFlight() {
        if (this.actual.isInFlight()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'in flight' (`isInFlight`)"), new Fact[0]);
        }
    }

    public void isNotNotInFlight() {
        if (this.actual.isNotInFlight()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'not in flight' (`isNotInFlight`)"), new Fact[0]);
        }
    }

    public void isUserFunctionComplete() {
        if (!this.actual.isUserFunctionComplete()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'user function complete' (`isUserFunctionComplete`)"), new Fact[0]);
        }
    }

    public void isNotUserFunctionComplete() {
        if (this.actual.isUserFunctionComplete()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'user function complete' (`isUserFunctionComplete`)"), new Fact[0]);
        }
    }

    public void isUserFunctionSucceeded() {
        if (!this.actual.isUserFunctionSucceeded()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'user function succeeded' (`isUserFunctionSucceeded`)"), new Fact[0]);
        }
    }

    public void isNotUserFunctionSucceeded() {
        if (this.actual.isUserFunctionSucceeded()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'user function succeeded' (`isUserFunctionSucceeded`)"), new Fact[0]);
        }
    }
}

