/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import io.confluent.parallelconsumer.FakeRuntimeException;
import io.confluent.parallelconsumer.ManagedTruth;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.RecordContext;
import io.confluent.parallelconsumer.internal.PCModule;
import io.confluent.parallelconsumer.internal.PCModuleTestEnv;
import io.confluent.parallelconsumer.state.ModelUtils;
import io.confluent.parallelconsumer.state.WorkContainer;
import java.time.Duration;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class WorkContainerTest {
    WorkContainerTest() {
    }

    @Test
    void basics() {
        WorkContainer<String, String> workContainer = new ModelUtils(new PCModuleTestEnv()).createWorkFor(0L);
        ManagedTruth.assertThat(workContainer).getDelayUntilRetryDue().isNegative();
    }

    @Test
    void retryDelayProvider() {
        int uniqueMultiplier = 7;
        Function<RecordContext, Duration> retryDelayProvider = context -> {
            int numberOfFailedAttempts = context.getNumberOfFailedAttempts();
            return Duration.ofSeconds(numberOfFailedAttempts * uniqueMultiplier);
        };
        ParallelConsumerOptions opts = ParallelConsumerOptions.builder().retryDelayProvider(retryDelayProvider).build();
        PCModuleTestEnv module = new PCModuleTestEnv((ParallelConsumerOptions<String, String>)opts);
        WorkContainer wc = new WorkContainer(0L, (ConsumerRecord)Mockito.mock(ConsumerRecord.class), (PCModule)module);
        int numberOfFailures = 3;
        wc.onUserFunctionFailure((Throwable)((Object)new FakeRuntimeException("")));
        wc.onUserFunctionFailure((Throwable)((Object)new FakeRuntimeException("")));
        wc.onUserFunctionFailure((Throwable)((Object)new FakeRuntimeException("")));
        Duration retryDelayConfig = wc.getRetryDelayConfig();
        ManagedTruth.assertThat(retryDelayConfig).getSeconds().isEqualTo((Object)(numberOfFailures * uniqueMultiplier));
    }
}

