/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.state;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.Subject;
import io.confluent.parallelconsumer.ParallelConsumerOptions;
import io.confluent.parallelconsumer.ParallelConsumerOptionsSubject;
import io.confluent.parallelconsumer.autoShaded.java.time.DurationSubject;
import io.confluent.parallelconsumer.state.PartitionStateManager;
import io.confluent.parallelconsumer.state.PartitionStateManagerSubject;
import io.confluent.parallelconsumer.state.ShardManager;
import io.confluent.parallelconsumer.state.ShardManagerSubject;
import io.confluent.parallelconsumer.state.WorkContainer;
import io.confluent.parallelconsumer.state.WorkManager;
import io.stubbs.truth.generator.subjects.MyCollectionSubject;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class WorkManagerParentSubject
extends Subject {
    protected final WorkManager actual;

    protected WorkManagerParentSubject(FailureMetadata failureMetadata, WorkManager actual) {
        super(failureMetadata, (Object)actual);
        this.actual = actual;
    }

    public DurationSubject getLowestRetryTime() {
        this.isNotNull();
        this.hasLowestRetryTimePresent();
        return (DurationSubject)this.check("getLowestRetryTime().get()", new Object[0]).about(DurationSubject.durations()).that((Object)((Duration)this.actual.getLowestRetryTime().get()));
    }

    public void hasLowestRetryTimeNotPresent() {
        if (this.actual.getLowestRetryTime().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected LowestRetryTime NOT to be present"), new Fact[0]);
        }
    }

    public void hasLowestRetryTimePresent() {
        if (!this.actual.getLowestRetryTime().isPresent()) {
            this.failWithActual(Fact.simpleFact((String)"expected LowestRetryTime to be present"), new Fact[0]);
        }
    }

    public void hasLowestRetryTimeNotEqualTo(Optional expected) {
        if (this.actual.getLowestRetryTime().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected LowestRetryTime NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasLowestRetryTimeEqualTo(Optional expected) {
        if (!this.actual.getLowestRetryTime().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected LowestRetryTime to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public LongSubject getNumberOfIncompleteOffsets() {
        this.isNotNull();
        return this.check("getNumberOfIncompleteOffsets()", new Object[0]).that(Long.valueOf(this.actual.getNumberOfIncompleteOffsets()));
    }

    public void hasNumberOfIncompleteOffsetsNotEqualTo(long expected) {
        if (this.actual.getNumberOfIncompleteOffsets() == expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfIncompleteOffsets NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasNumberOfIncompleteOffsetsEqualTo(long expected) {
        if (this.actual.getNumberOfIncompleteOffsets() != expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfIncompleteOffsets to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public LongSubject getNumberOfWorkQueuedInShardsAwaitingSelection() {
        this.isNotNull();
        return this.check("getNumberOfWorkQueuedInShardsAwaitingSelection()", new Object[0]).that(Long.valueOf(this.actual.getNumberOfWorkQueuedInShardsAwaitingSelection()));
    }

    public void hasNumberOfWorkQueuedInShardsAwaitingSelectionNotEqualTo(long expected) {
        if (this.actual.getNumberOfWorkQueuedInShardsAwaitingSelection() == expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfWorkQueuedInShardsAwaitingSelection NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasNumberOfWorkQueuedInShardsAwaitingSelectionEqualTo(long expected) {
        if (this.actual.getNumberOfWorkQueuedInShardsAwaitingSelection() != expected) {
            this.failWithActual(Fact.fact((String)"expected NumberOfWorkQueuedInShardsAwaitingSelection to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IntegerSubject getNumberRecordsOutForProcessing() {
        this.isNotNull();
        return this.check("getNumberRecordsOutForProcessing()", new Object[0]).that(Integer.valueOf(this.actual.getNumberRecordsOutForProcessing()));
    }

    public void hasNumberRecordsOutForProcessingNotEqualTo(int expected) {
        if (this.actual.getNumberRecordsOutForProcessing() == expected) {
            this.failWithActual(Fact.fact((String)"expected NumberRecordsOutForProcessing NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasNumberRecordsOutForProcessingEqualTo(int expected) {
        if (this.actual.getNumberRecordsOutForProcessing() != expected) {
            this.failWithActual(Fact.fact((String)"expected NumberRecordsOutForProcessing to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public ParallelConsumerOptionsSubject getOptions() {
        this.isNotNull();
        return (ParallelConsumerOptionsSubject)this.check("getOptions()", new Object[0]).about(ParallelConsumerOptionsSubject.parallelConsumerOptionses()).that((Object)this.actual.getOptions());
    }

    public void hasOptionsNotEqualTo(ParallelConsumerOptions expected) {
        if (this.actual.getOptions().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Options NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasOptionsEqualTo(ParallelConsumerOptions expected) {
        if (!this.actual.getOptions().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Options to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public PartitionStateManagerSubject getPm() {
        this.isNotNull();
        return (PartitionStateManagerSubject)this.check("getPm()", new Object[0]).about(PartitionStateManagerSubject.partitionStateManagers()).that((Object)this.actual.getPm());
    }

    public void hasPmNotEqualTo(PartitionStateManager expected) {
        if (this.actual.getPm().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Pm NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasPmEqualTo(PartitionStateManager expected) {
        if (!this.actual.getPm().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Pm to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public ShardManagerSubject getSm() {
        this.isNotNull();
        return (ShardManagerSubject)this.check("getSm()", new Object[0]).about(ShardManagerSubject.shardManagers()).that((Object)this.actual.getSm());
    }

    public void hasSmNotEqualTo(ShardManager expected) {
        if (this.actual.getSm().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Sm NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasSmEqualTo(ShardManager expected) {
        if (!this.actual.getSm().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected Sm to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public MyCollectionSubject getSuccessfulWorkListeners() {
        this.isNotNull();
        return (MyCollectionSubject)this.check("getSuccessfulWorkListeners()", new Object[0]).about(MyCollectionSubject.collections()).that((Object)this.actual.getSuccessfulWorkListeners());
    }

    public void hasSuccessfulWorkListenersNotWithElement(Consumer expected) {
        if (!this.actual.getSuccessfulWorkListeners().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected SuccessfulWorkListeners NOT to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasSuccessfulWorkListenersWithElement(Consumer expected) {
        if (this.actual.getSuccessfulWorkListeners().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected SuccessfulWorkListeners to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasSuccessfulWorkListenersNotEqualTo(List expected) {
        if (this.actual.getSuccessfulWorkListeners().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected SuccessfulWorkListeners NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasSuccessfulWorkListenersEqualTo(List expected) {
        if (!this.actual.getSuccessfulWorkListeners().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected SuccessfulWorkListeners to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public MyCollectionSubject getWorkIfAvailable() {
        this.isNotNull();
        return (MyCollectionSubject)this.check("getWorkIfAvailable()", new Object[0]).about(MyCollectionSubject.collections()).that((Object)this.actual.getWorkIfAvailable());
    }

    public void hasWorkIfAvailableNotWithElement(WorkContainer expected) {
        if (!this.actual.getWorkIfAvailable().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected WorkIfAvailable NOT to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasWorkIfAvailableWithElement(WorkContainer expected) {
        if (this.actual.getWorkIfAvailable().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected WorkIfAvailable to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasWorkIfAvailableNotEqualTo(List expected) {
        if (this.actual.getWorkIfAvailable().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected WorkIfAvailable NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasWorkIfAvailableEqualTo(List expected) {
        if (!this.actual.getWorkIfAvailable().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected WorkIfAvailable to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void isDirty() {
        if (!this.actual.isDirty()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'dirty' (`isDirty`)"), new Fact[0]);
        }
    }

    public void isNotDirty() {
        if (this.actual.isDirty()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'dirty' (`isDirty`)"), new Fact[0]);
        }
    }

    public void isNoRecordsOutForProcessing() {
        if (!this.actual.isNoRecordsOutForProcessing()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'no records out for processing' (`isNoRecordsOutForProcessing`)"), new Fact[0]);
        }
    }

    public void isNotNoRecordsOutForProcessing() {
        if (this.actual.isNoRecordsOutForProcessing()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'no records out for processing' (`isNoRecordsOutForProcessing`)"), new Fact[0]);
        }
    }

    public void isRecordsAwaitingProcessing() {
        if (!this.actual.isRecordsAwaitingProcessing()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'records awaiting processing' (`isRecordsAwaitingProcessing`)"), new Fact[0]);
        }
    }

    public void isNotRecordsAwaitingProcessing() {
        if (this.actual.isRecordsAwaitingProcessing()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'records awaiting processing' (`isRecordsAwaitingProcessing`)"), new Fact[0]);
        }
    }

    public void isSufficientlyLoaded() {
        if (!this.actual.isSufficientlyLoaded()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'sufficiently loaded' (`isSufficientlyLoaded`)"), new Fact[0]);
        }
    }

    public void isNotSufficientlyLoaded() {
        if (this.actual.isSufficientlyLoaded()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'sufficiently loaded' (`isSufficientlyLoaded`)"), new Fact[0]);
        }
    }

    public void isWorkInFlightMeetingTarget() {
        if (!this.actual.isWorkInFlightMeetingTarget()) {
            this.failWithActual(Fact.simpleFact((String)"expected to be 'work in flight meeting target' (`isWorkInFlightMeetingTarget`)"), new Fact[0]);
        }
    }

    public void isNotWorkInFlightMeetingTarget() {
        if (this.actual.isWorkInFlightMeetingTarget()) {
            this.failWithActual(Fact.simpleFact((String)"expected NOT to be 'work in flight meeting target' (`isWorkInFlightMeetingTarget`)"), new Fact[0]);
        }
    }
}

