/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.truth;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.OptionalSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import io.confluent.parallelconsumer.model.CommitHistory;
import io.stubbs.truth.generator.SubjectFactoryMethod;
import io.stubbs.truth.generator.UserManagedSubject;
import java.util.Arrays;
import java.util.Optional;
import java.util.SortedSet;
import java.util.stream.Collectors;

@UserManagedSubject(value=CommitHistory.class)
public class CommitHistorySubject
extends Subject {
    private final CommitHistory actual;

    protected CommitHistorySubject(FailureMetadata metadata, CommitHistory actual) {
        super(metadata, (Object)actual);
        this.actual = actual;
    }

    @SubjectFactoryMethod
    public static Subject.Factory<CommitHistorySubject, CommitHistory> commitHistories() {
        return CommitHistorySubject::new;
    }

    public static CommitHistorySubject assertTruth(CommitHistory actual) {
        return CommitHistorySubject.assertThat(actual);
    }

    public static CommitHistorySubject assertThat(CommitHistory actual) {
        return (CommitHistorySubject)Truth.assertAbout(CommitHistorySubject.commitHistories()).that((Object)actual);
    }

    public void atLeastOffset(long needleCommit) {
        Optional<Long> highestCommitOpt = this.actual.highestCommit();
        ((OptionalSubject)this.check("highestCommit()", new Object[0]).about(OptionalSubject.optionals()).that(highestCommitOpt)).isPresent();
        this.check("highestCommit().atLeastOffset()", new Object[0]).that(highestCommitOpt.get()).isAtLeast((Comparable)Long.valueOf(needleCommit));
    }

    public void offset(long quantity) {
        this.check("getOffsetHistory()", new Object[0]).that(this.actual.getOffsetHistory()).contains((Object)quantity);
    }

    public void anything() {
        this.check("commits()", new Object[0]).that(this.actual.getOffsetHistory()).isNotEmpty();
    }

    public void nothing() {
        this.check("commits()", new Object[0]).that(this.actual.getOffsetHistory()).isEmpty();
    }

    public void isEmpty() {
        this.nothing();
    }

    public void encodedIncomplete(int ... expectedEncodedOffsetsArray) {
        SortedSet incompleteOffsets = this.actual.getEncodedSucceeded().getIncompleteOffsets();
        this.check("encodedSucceeded()", new Object[0]).that((Iterable)incompleteOffsets).containsExactlyElementsIn((Iterable)Arrays.stream(expectedEncodedOffsetsArray).boxed().map(Long::valueOf).collect(Collectors.toList()));
    }

    public void encodingEmpty() {
        this.check("encodedMetadata()", new Object[0]).that(this.actual.getEncoding()).isEmpty();
    }

    public String toString() {
        return "CommitHistorySubject(actual=" + this.actual + ")";
    }
}

