/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.truth;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import io.stubbs.truth.generator.SubjectFactoryMethod;
import io.stubbs.truth.generator.UserManagedMiddleSubject;
import io.stubbs.truth.generator.UserManagedSubject;
import java.util.Iterator;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.ConsumerRecordsParentSubject;
import org.jetbrains.annotations.NotNull;

@UserManagedSubject(value=ConsumerRecords.class)
public class ConsumerRecordsSubject
extends ConsumerRecordsParentSubject
implements UserManagedMiddleSubject {
    protected ConsumerRecordsSubject(FailureMetadata failureMetadata, ConsumerRecords actual) {
        super(failureMetadata, actual);
    }

    @SubjectFactoryMethod
    public static Subject.Factory<ConsumerRecordsSubject, ConsumerRecords> consumerRecordses() {
        return ConsumerRecordsSubject::new;
    }

    public void hasHeadOffsetAtLeastInAnyTopicPartition(int target) {
        long highestOffset = this.findHighestOffsetAnyPartition();
        this.check("headOffset", new Object[0]).that(Long.valueOf(highestOffset)).isAtLeast(target);
    }

    public void hasHeadOffsetAtMostInAnyTopicPartition(int atMost) {
        long highestOffset = this.findHighestOffsetAnyPartition();
        this.check("headOffset", new Object[0]).that(Long.valueOf(highestOffset)).isAtMost(atMost);
    }

    private long findHighestOffsetAnyPartition() {
        Iterator<ConsumerRecord<?, ?>> iterator = this.getConsumerRecordIterator();
        long highestOffset = -1L;
        while (iterator.hasNext()) {
            long offset;
            ConsumerRecord<?, ?> next = iterator.next();
            highestOffset = offset = next.offset();
        }
        return highestOffset;
    }

    @NotNull
    private Iterator<ConsumerRecord<?, ?>> getConsumerRecordIterator() {
        return this.actual.iterator();
    }
}

