/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.truth;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import io.confluent.parallelconsumer.model.CommitHistory;
import io.confluent.parallelconsumer.truth.CommitHistorySubject;
import io.stubbs.truth.generator.SubjectFactoryMethod;
import io.stubbs.truth.generator.UserManagedSubject;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerParentSubject;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import pl.tlinkowski.unij.api.UniLists;
import pl.tlinkowski.unij.api.UniSets;

@UserManagedSubject(value=Consumer.class)
public class ConsumerSubject
extends ConsumerParentSubject {
    private final Duration timeout = Duration.ofSeconds(10L);

    protected ConsumerSubject(FailureMetadata failureMetadata, Consumer actual) {
        super(failureMetadata, actual);
    }

    @SubjectFactoryMethod
    public static Subject.Factory<ConsumerSubject, Consumer> consumers() {
        return ConsumerSubject::new;
    }

    public CommitHistorySubject hasCommittedToPartition(String topic, int partition) {
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        return this.hasCommittedToPartition(topicPartition);
    }

    public CommitHistorySubject hasCommittedToPartition(TopicPartition topicPartitions) {
        Map<TopicPartition, CommitHistorySubject> rawCommitHistory = this.hasCommittedToPartition(UniSets.of((Object)topicPartitions));
        return rawCommitHistory.values().stream().findFirst().orElse((CommitHistorySubject)this.check("getCommitHistory(%s)", new Object[]{topicPartitions.topic()}).about(CommitHistorySubject.commitHistories()).that((Object)new CommitHistory(UniLists.of())));
    }

    public Map<TopicPartition, CommitHistorySubject> hasCommittedToPartition(Set<TopicPartition> partitions) {
        Map committed = this.actual.committed(partitions, this.timeout);
        return ((StreamEx)StreamEx.of(committed.entrySet()).filter(entry -> entry.getValue() != null)).toMap(entry -> (TopicPartition)entry.getKey(), entry -> (CommitHistorySubject)this.check("getCommitHistory(%s)", new Object[]{((TopicPartition)entry.getKey()).topic() + ":" + ((TopicPartition)entry.getKey()).partition()}).about(CommitHistorySubject.commitHistories()).that((Object)new CommitHistory(UniLists.of((Object)((OffsetAndMetadata)entry.getValue())))));
    }
}

