/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.parallelconsumer.truth;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import io.confluent.csid.utils.LongPollingMockConsumer;
import io.confluent.parallelconsumer.model.CommitHistory;
import io.confluent.parallelconsumer.truth.CommitHistorySubject;
import io.stubbs.truth.generator.SubjectFactoryMethod;
import io.stubbs.truth.generator.UserManagedSubject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

@UserManagedSubject(value=LongPollingMockConsumer.class)
public class LongPollingMockConsumerSubject<K, V>
extends Subject {
    private final LongPollingMockConsumer<K, V> actual;

    protected LongPollingMockConsumerSubject(FailureMetadata metadata, LongPollingMockConsumer<K, V> actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    @SubjectFactoryMethod
    public static <K, V> Subject.Factory<LongPollingMockConsumerSubject<K, V>, LongPollingMockConsumer<K, V>> mockConsumers() {
        return LongPollingMockConsumerSubject::new;
    }

    public static <K, V> LongPollingMockConsumerSubject<K, V> assertTruth(LongPollingMockConsumer<K, V> actual) {
        return LongPollingMockConsumerSubject.assertThat(actual);
    }

    public static <K, V> LongPollingMockConsumerSubject<K, V> assertThat(LongPollingMockConsumer<K, V> actual) {
        Subject.Factory<LongPollingMockConsumerSubject<K, V>, LongPollingMockConsumer<K, V>> factory = LongPollingMockConsumerSubject.mockConsumers();
        return (LongPollingMockConsumerSubject)Truth.assertAbout(factory).that(actual);
    }

    public CommitHistorySubject hasCommittedToPartition(TopicPartition tp) {
        this.isNotNull();
        CopyOnWriteArrayList<Map<TopicPartition, OffsetAndMetadata>> allCommits = this.actual.getCommitHistoryInt();
        List<OffsetAndMetadata> historyForCommitsToPartition = allCommits.stream().filter(aCommitInstance -> aCommitInstance.containsKey(tp)).map(aCommitInstance -> (OffsetAndMetadata)aCommitInstance.get(tp)).collect(Collectors.toList());
        CommitHistory commitHistory = new CommitHistory(historyForCommitsToPartition);
        return (CommitHistorySubject)this.check("getCommitHistory(%s)", new Object[]{tp}).about(CommitHistorySubject.commitHistories()).that((Object)commitHistory);
    }

    public CommitHistorySubject hasCommittedToAnyPartition() {
        this.isNotNull();
        CopyOnWriteArrayList<Map<TopicPartition, OffsetAndMetadata>> allCommits = this.actual.getCommitHistoryInt();
        List<OffsetAndMetadata> historyForCommitsToPartition = allCommits.stream().flatMap(aCommitInstance -> aCommitInstance.values().stream()).collect(Collectors.toList());
        CommitHistory commitHistory = new CommitHistory(historyForCommitsToPartition);
        return (CommitHistorySubject)this.check("getCommitHistory()", new Object[0]).about(CommitHistorySubject.commitHistories()).that((Object)commitHistory);
    }
}

