/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import io.confluent.parallelconsumer.autoShaded.java.util.IteratorSubject;
import io.confluent.parallelconsumer.autoShaded.java.util.SpliteratorSubject;
import io.stubbs.truth.generator.subjects.MyCollectionSubject;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;

public class ConsumerRecordsParentSubject
extends IterableSubject {
    protected final ConsumerRecords actual;

    protected ConsumerRecordsParentSubject(FailureMetadata failureMetadata, ConsumerRecords actual) {
        super(failureMetadata, (Iterable)actual);
        this.actual = actual;
    }

    public IntegerSubject getCount() {
        this.isNotNull();
        return this.check("count()", new Object[0]).that(Integer.valueOf(this.actual.count()));
    }

    public void hasCountNotEqualTo(int expected) {
        if (this.actual.count() == expected) {
            this.failWithActual(Fact.fact((String)"expected count NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasCountEqualTo(int expected) {
        if (this.actual.count() != expected) {
            this.failWithActual(Fact.fact((String)"expected count to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public IteratorSubject getIterator() {
        this.isNotNull();
        return (IteratorSubject)this.check("iterator()", new Object[0]).about(IteratorSubject.iterators()).that((Object)this.actual.iterator());
    }

    public void hasIteratorNotEqualTo(Iterator expected) {
        if (this.actual.iterator().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected iterator NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasIteratorEqualTo(Iterator expected) {
        if (!this.actual.iterator().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected iterator to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public MyCollectionSubject getPartitions() {
        this.isNotNull();
        return (MyCollectionSubject)this.check("partitions()", new Object[0]).about(MyCollectionSubject.collections()).that((Object)this.actual.partitions());
    }

    public void hasPartitionsNotWithElement(TopicPartition expected) {
        if (!this.actual.partitions().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected partitions NOT to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasPartitionsWithElement(TopicPartition expected) {
        if (this.actual.partitions().contains(expected)) {
            this.failWithActual(Fact.fact((String)"expected partitions to have element", (Object)expected), new Fact[0]);
        }
    }

    public void hasPartitionsNotEqualTo(Set expected) {
        if (this.actual.partitions().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected partitions NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasPartitionsEqualTo(Set expected) {
        if (!this.actual.partitions().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected partitions to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public SpliteratorSubject getSpliterator() {
        this.isNotNull();
        return (SpliteratorSubject)this.check("spliterator()", new Object[0]).about(SpliteratorSubject.spliterators()).that((Object)this.actual.spliterator());
    }

    public void hasSpliteratorNotEqualTo(Spliterator expected) {
        if (this.actual.spliterator().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected spliterator NOT to be equal to", (Object)expected), new Fact[0]);
        }
    }

    public void hasSpliteratorEqualTo(Spliterator expected) {
        if (!this.actual.spliterator().equals(expected)) {
            this.failWithActual(Fact.fact((String)"expected spliterator to be equal to", (Object)expected), new Fact[0]);
        }
    }
}

