/*
 * Decompiled with CFR 0.152.
 */
package io.confound.config.urf;

import com.globalmentor.java.Conditions;
import io.confound.config.AbstractObjectConfiguration;
import io.confound.config.Configuration;
import io.confound.config.ConfigurationException;
import io.urf.model.UrfObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UrfConfiguration
extends AbstractObjectConfiguration {
    private final Object root;
    private static final char KEY_HIERARCHY_DELIMITER = '.';
    private static final Pattern KEY_HIERARCHY_DELIMITER_PATTERN = Pattern.compile(Pattern.quote(String.valueOf('.')));

    public UrfConfiguration(@Nonnull Object root) {
        this(root, null);
    }

    public UrfConfiguration(@Nonnull Object root, @Nullable Configuration parentConfiguration) {
        super(parentConfiguration);
        this.root = Objects.requireNonNull(root);
    }

    protected Optional<Object> findParameterImpl(String key) throws ConfigurationException {
        Object object = this.root;
        for (String keySegment : KEY_HIERARCHY_DELIMITER_PATTERN.split(key, -1)) {
            Conditions.checkArgument((!keySegment.isEmpty() ? 1 : 0) != 0, (String)"Configuration key %s cannot have an empty hiararchy segment.", (Object[])new Object[]{key});
            if (object == null) continue;
            object = object instanceof UrfObject ? ((UrfObject)object).getPropertyValue(keySegment).orElse(null) : (object instanceof Map ? ((Map)object).get(Objects.requireNonNull(keySegment)) : null);
        }
        return Optional.ofNullable(object);
    }
}

