/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.core.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Property {
    private String name;
    private final Method getterMethod;
    private final Method setterMethod;
    private final Field field;
    private final Class<?> propertyType;

    public Property(String name, Method getterMethod, Method setterMethod, Field field, Class<?> propertyType) {
        this.name = name;
        this.getterMethod = getterMethod;
        this.setterMethod = setterMethod;
        this.field = field;
        this.propertyType = propertyType;
    }

    public void setCustomName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Method getGetterMethod() {
        return this.getterMethod;
    }

    public Method getSetterMethod() {
        return this.setterMethod;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public Field getField() {
        return this.field;
    }

    public String toString() {
        return this.name;
    }

    public Object read(Object target) {
        try {
            return this.getterMethod.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(Object target, Object value) {
        try {
            this.setterMethod.invoke(target, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

