/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.controller.k8s;

import io.continual.builder.Builder;
import io.continual.flowcontrol.impl.common.Enc;
import io.continual.flowcontrol.impl.controller.k8s.K8sController;
import io.continual.flowcontrol.impl.jobdb.model.ModelJobDb;
import io.continual.flowcontrol.model.FlowControlCallContext;
import io.continual.flowcontrol.model.FlowControlDeploymentRecord;
import io.continual.flowcontrol.model.FlowControlDeploymentService;
import io.continual.iam.identity.Identity;
import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import io.continual.services.model.impl.mem.InMemoryModel;
import io.continual.util.console.CmdLineParser;
import io.continual.util.console.CmdLinePrefs;
import io.continual.util.console.ConfiguredConsole;
import io.continual.util.console.ConsoleProgram;
import io.continual.util.nv.NvReadable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sClientAuthTester
extends ConfiguredConsole {
    private static final String kContext = "context";
    private static final String kNamespace = "namespace";
    private static final Logger log = LoggerFactory.getLogger(K8sClientAuthTester.class);

    protected ConfiguredConsole setupOptions(CmdLineParser p) {
        super.setupOptions(p);
        p.registerOptionWithValue(kContext);
        p.registerOptionWithValue(kNamespace);
        return this;
    }

    protected ConsoleProgram.Looper init(NvReadable p, CmdLinePrefs clp) throws NvReadable.MissingReqdSettingException, NvReadable.InvalidSettingValueException, ConsoleProgram.StartupFailureException {
        try {
            String namespace;
            ServiceContainer sc = new ServiceContainer();
            Enc enc = new Enc(sc, new JSONObject().put("key", (Object)"test"));
            sc.add("encryptor", (Service)enc);
            ModelJobDb jobDb = new ModelJobDb(sc, new JSONObject().put("model", (Object)new JSONObject().put("class", (Object)InMemoryModel.class.getCanonicalName()).put("modelId", (Object)"test")));
            sc.add("jobDb", (Service)jobDb);
            log.info("Building Kubernetes controller config...");
            JSONObject config = new JSONObject();
            String context = clp.getString(kContext, null);
            if (context != null) {
                log.info("    context: " + context);
                config.put("kubeConfigContext", (Object)context);
            }
            if ((namespace = clp.getString(kNamespace, "default")) != null) {
                log.info("    namespace: " + namespace);
                config.put(kNamespace, (Object)namespace);
            }
            log.info("... complete");
            log.info("Creating Kubernetes controller service object...");
            K8sController ctrl = new K8sController(sc, config);
            log.info("... complete");
            FlowControlCallContext fccc = new FlowControlCallContext(){

                public Identity getUser() {
                    return null;
                }
            };
            log.info("Requesting deployments...");
            for (FlowControlDeploymentRecord d : ctrl.getDeployments(fccc)) {
                log.info("... job: " + d.getId());
            }
            log.info("... complete");
        }
        catch (Builder.BuildFailure | FlowControlDeploymentService.ServiceException e) {
            log.warn(e.getMessage(), e);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        K8sClientAuthTester tester = new K8sClientAuthTester();
        tester.runFromMain(args);
    }
}

