/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.controller.k8s;

import io.continual.builder.Builder;
import io.continual.builder.BuilderDataSource;
import io.continual.builder.sources.BuilderJsonDataSource;
import io.continual.flowcontrol.impl.controller.k8s.FlowControlK8sElement;
import io.continual.flowcontrol.impl.controller.k8s.elements.SecretDeployer;
import io.continual.flowcontrol.impl.controller.k8s.impl.ContainerImageMapper;
import io.continual.flowcontrol.impl.controller.k8s.impl.NoMapImageMapper;
import io.continual.flowcontrol.impl.deployer.BaseDeployer;
import io.continual.flowcontrol.model.Encryptor;
import io.continual.flowcontrol.model.FlowControlCallContext;
import io.continual.flowcontrol.model.FlowControlDeploymentRecord;
import io.continual.flowcontrol.model.FlowControlDeploymentService;
import io.continual.flowcontrol.model.FlowControlDeploymentSpec;
import io.continual.flowcontrol.model.FlowControlJob;
import io.continual.flowcontrol.model.FlowControlRuntimeState;
import io.continual.flowcontrol.model.FlowControlRuntimeSystem;
import io.continual.iam.access.AccessControlList;
import io.continual.iam.identity.Identity;
import io.continual.services.ServiceContainer;
import io.continual.util.data.StringUtils;
import io.continual.util.data.json.JsonVisitor;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.KubeConfig;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.introspector.PropertySubstitute;

public class K8sController
extends BaseDeployer
implements FlowControlRuntimeSystem {
    static final String kSetting_ConfigMountLoc = "configMountLoc";
    static final String kDefault_ConfigMountLoc = "/var/flowcontrol/config";
    static final String kSetting_PersistMountLoc = "persistMountLoc";
    static final String kDefault_PersistMountLoc = "/var/flowcontrol/persistence";
    static final String kSetting_LogsMountLoc = "logsMountLoc";
    static final String kDefault_LogsMountLoc = "/var/flowcontrol/logs";
    static final String kSetting_InitYamlResource = "deploymentYaml";
    static final String kDefault_InitYamlResource = "initDeployment.yaml";
    static final String kSetting_ImagePullSecrets = "imagePullSecrets";
    static final String kSetting_InstallationName = "installationName";
    static final String kSetting_InternalConfigUrl = "internalConfigUrl";
    static final String kSetting_DumpInitYaml = "dumpInitYaml";
    static final String kSetting_Elements = "elements";
    static final String kSetting_EncryptorSvc = "encryptor";
    static final String kDefault_EncryptorSvc = "encryptor";
    static final String kSetting_ImageMapper = "imageMapper";
    static final String kSetting_UseKubeConfig = "useKubeConfig";
    static final boolean kDefault_UseKubeConfig = true;
    static final String kSetting_KubeConfigFile = "kubeConfig";
    static final String kDefault_KubeConfigFile = System.getenv("HOME") + "/.kube/config";
    static final String kSetting_k8sContext = "kubeConfigContext";
    static final String kSetting_K8sNamespace = "namespace";
    private final Encryptor fEncryptor;
    private final String fK8sNamespace;
    private final String fConfigMountLoc;
    private final String fPersistMountLoc;
    private final String fLogsMountLoc;
    private final ContainerImageMapper fImageMapper;
    private final String fInstallationName;
    private final List<String> fImgPullSecrets;
    private final LinkedList<FlowControlK8sElement> fElements;
    private final String fInternalConfigBaseUrl;
    private static final Logger log = LoggerFactory.getLogger(K8sController.class);

    public K8sController(ServiceContainer sc, JSONObject rawConfig) throws Builder.BuildFailure {
        super(sc, rawConfig);
        JSONObject config = sc.getExprEval().evaluateJsonObject(rawConfig);
        this.fK8sNamespace = config.getString(kSetting_K8sNamespace);
        this.setupK8sConfig(config, this.fK8sNamespace);
        JSONObject mapperSpec = config.optJSONObject(kSetting_ImageMapper);
        if (mapperSpec != null) {
            log.info("Building image mapper from {} setting.", (Object)kSetting_ImageMapper);
            this.fImageMapper = (ContainerImageMapper)Builder.fromJson(ContainerImageMapper.class, (JSONObject)mapperSpec, (Object)sc);
        } else {
            log.info("Using default (name:version) image mapper");
            this.fImageMapper = new NoMapImageMapper();
        }
        this.fEncryptor = (Encryptor)sc.getReqd(config.optString("encryptor", "encryptor"), Encryptor.class);
        this.fImgPullSecrets = JsonVisitor.arrayToList((JSONArray)config.optJSONArray(kSetting_ImagePullSecrets));
        this.fConfigMountLoc = config.optString(kSetting_ConfigMountLoc, kDefault_ConfigMountLoc);
        this.fPersistMountLoc = config.optString(kSetting_PersistMountLoc, kDefault_PersistMountLoc);
        this.fLogsMountLoc = config.optString(kSetting_LogsMountLoc, kDefault_LogsMountLoc);
        this.fInstallationName = config.optString(kSetting_InstallationName, "");
        this.fInternalConfigBaseUrl = config.optString(kSetting_InternalConfigUrl, "localhost:8080");
        this.fElements = new LinkedList();
        JsonVisitor.forEachElement((JSONArray)config.optJSONArray(kSetting_Elements), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, Builder.BuildFailure>(){

            public boolean visit(JSONObject element) throws JSONException, Builder.BuildFailure {
                FlowControlK8sElement elementBuilder = (FlowControlK8sElement)Builder.withBaseClass(FlowControlK8sElement.class).withClassNameInData().searchingPath(SecretDeployer.class.getPackageName()).usingData((BuilderDataSource)new BuilderJsonDataSource(element)).build();
                K8sController.this.fElements.add(elementBuilder);
                return true;
            }
        });
    }

    protected FlowControlDeploymentRecord internalDeploy(FlowControlCallContext ctx, final FlowControlDeploymentSpec ds, String configKey) throws FlowControlDeploymentService.ServiceException, FlowControlDeploymentService.RequestException {
        try {
            String k8sDeployId;
            String jobId = ds.getJob().getId();
            String tag = k8sDeployId = K8sController.makeK8sName(jobId);
            FlowControlJob.FlowControlRuntimeSpec runtimeSpec = ds.getJob().getRuntimeSpec();
            if (runtimeSpec == null) {
                throw new FlowControlDeploymentService.RequestException("There's no runtime spec on this job.");
            }
            final String runtimeImage = this.fImageMapper.getImageName(runtimeSpec);
            final HashMap<String, Object> env = new HashMap<String, Object>();
            env.putAll(ds.getEnv());
            env.put("FC_DEPLOYMENT_NAME", k8sDeployId);
            env.put("FC_JOB_TAG", "job-" + k8sDeployId);
            env.put("FC_JOB_ID", jobId);
            env.put("FC_CONFIG_URL", this.configKeyToUrl(configKey));
            env.put("FC_CONFIG_MOUNT", this.fConfigMountLoc);
            env.put("FC_CONFIG_FILE", this.fConfigMountLoc + "/jobConfig.json");
            env.put("FC_PERSISTENCE_MOUNT", this.fPersistMountLoc);
            env.put("FC_LOGS_MOUNT", this.fLogsMountLoc);
            env.put("FC_RUNTIME_IMAGE", runtimeImage);
            env.put("EP_CMDLINE_ARGS", this.fConfigMountLoc + "/jobConfig.json");
            final JSONObject workspace = new JSONObject();
            FlowControlK8sElement.K8sDeployContext deployContext = new FlowControlK8sElement.K8sDeployContext(){
                final /* synthetic */ K8sController this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public String getInstallationName() {
                    return this.this$0.fInstallationName;
                }

                @Override
                public String getNamespace() {
                    return this.this$0.fK8sNamespace;
                }

                @Override
                public String getDeployId() {
                    return k8sDeployId;
                }

                @Override
                public FlowControlDeploymentSpec getDeploymentSpec() {
                    return ds;
                }

                @Override
                public String getRuntimeImage() {
                    return runtimeImage;
                }

                @Override
                public Encryptor getEncryptor() {
                    return this.this$0.fEncryptor;
                }

                @Override
                public JSONObject getWorkspace() {
                    return workspace;
                }

                @Override
                public Map<String, String> getEnvironment() {
                    return env;
                }

                @Override
                public List<String> getImagePullSecrets() {
                    return this.this$0.fImgPullSecrets;
                }

                @Override
                public FlowControlK8sElement.ImagePullPolicy getImagePullPolicy() {
                    FlowControlK8sElement.ImagePullPolicy ipp = FlowControlK8sElement.ImagePullPolicy.IfNotPresent;
                    if (runtimeImage.endsWith("-SNAPSHOT")) {
                        ipp = FlowControlK8sElement.ImagePullPolicy.Always;
                    }
                    return ipp;
                }
            };
            for (FlowControlK8sElement element : this.fElements) {
                log.info("deploying k8s element {}", (Object)element);
                element.deploy(deployContext);
            }
            log.info("all k8s elements deployed");
            return new IntDeployment(tag, AccessControlList.createOpenAcl(), ds, ctx.getUser(), configKey);
        }
        catch (FlowControlK8sElement.ElementDeployException x) {
            throw new FlowControlDeploymentService.ServiceException((Throwable)x);
        }
    }

    private FlowControlK8sElement.K8sInstallationContext makeInstallContext(final String deploymentId) {
        return new FlowControlK8sElement.K8sInstallationContext(){
            final /* synthetic */ K8sController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String getInstallationName() {
                return this.this$0.fInstallationName;
            }

            @Override
            public String getNamespace() {
                return this.this$0.fK8sNamespace;
            }

            @Override
            public String getDeployId() {
                return deploymentId;
            }
        };
    }

    protected void internalUndeploy(FlowControlCallContext ctx, String deploymentId, FlowControlDeploymentRecord deployment) throws FlowControlDeploymentService.ServiceException {
        try {
            FlowControlK8sElement.K8sInstallationContext installationContext = this.makeInstallContext(deploymentId);
            LinkedList<FlowControlK8sElement> reversed = new LinkedList<FlowControlK8sElement>(this.fElements);
            Collections.reverse(reversed);
            for (FlowControlK8sElement element : reversed) {
                element.undeploy(installationContext);
            }
        }
        catch (FlowControlK8sElement.ElementDeployException x) {
            throw new FlowControlDeploymentService.ServiceException((Throwable)x);
        }
    }

    public FlowControlRuntimeState getRuntimeState(FlowControlCallContext fccc, String deploymentId) throws FlowControlDeploymentService.ServiceException {
        for (FlowControlK8sElement e : this.fElements) {
            if (!e.isRuntimeProvider()) continue;
            try {
                FlowControlK8sElement.K8sInstallationContext installationContext = this.makeInstallContext(deploymentId);
                if (!e.isDeployed(installationContext)) {
                    return null;
                }
                return e.getRuntimeState(installationContext);
            }
            catch (FlowControlK8sElement.ElementDeployException x) {
                throw new FlowControlDeploymentService.ServiceException((Throwable)x);
            }
        }
        throw new FlowControlDeploymentService.ServiceException("No Kubernetes deployment elements identify as providing a runtime environment. (This is a service configuration error.)");
    }

    private String configKeyToUrl(String configKey) {
        return StringUtils.appendIfMissing((String)this.fInternalConfigBaseUrl, (String)"/") + "config/" + configKey;
    }

    private static String makeK8sName(String from) {
        return from.toLowerCase();
    }

    private void setupK8sConfig(JSONObject config, String namespace) throws Builder.BuildFailure {
        try {
            ApiClient client;
            boolean useKubeConfig = config.optBoolean(kSetting_UseKubeConfig, true);
            String kubeConfigFile = config.optString(kSetting_KubeConfigFile, kDefault_KubeConfigFile);
            if (useKubeConfig || config.has(kSetting_KubeConfigFile) && StringUtils.isNotEmpty((String)kubeConfigFile)) {
                log.info("Building k8s API config from kube config [" + kubeConfigFile + "]");
                KubeConfig kc = KubeConfig.loadKubeConfig((Reader)new FileReader(kubeConfigFile));
                String contextName = config.optString(kSetting_k8sContext, null);
                if (StringUtils.isNotEmpty((String)contextName)) {
                    log.info("Using kubectl context [{}]", (Object)contextName);
                    kc.setContext(contextName);
                } else {
                    log.warn("\ud83e\udd14 Using kubectl's current context. (It's a good idea to explicitly configure '{}'.)", (Object)kSetting_k8sContext);
                }
                try {
                    client = ClientBuilder.kubeconfig((KubeConfig)kc).build();
                }
                catch (IllegalArgumentException x) {
                    throw new Builder.BuildFailure((Throwable)x);
                }
            } else {
                log.info("Building k8s API config from in-cluster service account data");
                client = ClientBuilder.cluster().build();
            }
            Configuration.setDefaultApiClient((ApiClient)client);
        }
        catch (IOException x) {
            throw new Builder.BuildFailure((Throwable)x);
        }
    }

    static {
        java.util.logging.Logger snakeLog = java.util.logging.Logger.getLogger(PropertySubstitute.class.getPackage().getName());
        snakeLog.setLevel(Level.SEVERE);
        snakeLog = java.util.logging.Logger.getLogger("org.yaml.snakeyaml.introspector");
        snakeLog.setLevel(Level.SEVERE);
    }

    private class IntDeployment
    implements FlowControlDeploymentRecord {
        private final String fTag;
        private final AccessControlList fAcl;
        private final Identity fDeployer;
        private final FlowControlDeploymentSpec fDeploymentSpec;
        private final String fConfigKey;

        public IntDeployment(String tag, AccessControlList acl, FlowControlDeploymentSpec ds, Identity deployer, String configKey) {
            this.fTag = tag;
            this.fAcl = acl;
            this.fDeployer = deployer;
            this.fDeploymentSpec = ds;
            this.fConfigKey = configKey;
        }

        public String getId() {
            return this.fTag;
        }

        public AccessControlList getAccessControlList() {
            return this.fAcl;
        }

        public FlowControlDeploymentSpec getDeploymentSpec() {
            return this.fDeploymentSpec;
        }

        public Identity getDeployer() {
            return this.fDeployer;
        }

        public String getConfigToken() {
            return this.fConfigKey;
        }
    }
}

