/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.controller.k8s.elements;

import io.continual.flowcontrol.impl.controller.k8s.FlowControlK8sElement;
import io.continual.resources.ResourceLoader;
import io.continual.util.data.StreamTools;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapBuilder;
import io.kubernetes.client.openapi.models.V1ConfigMapFluent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPullScriptDeployer
implements FlowControlK8sElement {
    public static final String kWorkspaceKey_ConfigPullScriptConfigMap = "configPullConfigMap";
    public static final String kWorkspaceKey_ConfigPullScriptName = "configfPullScriptName";
    public static final String kWorkspaceVal_ConfigPullScriptName = "sysprep";
    private final String fConfigMapScriptResource;
    private static final Logger log = LoggerFactory.getLogger(ConfigPullScriptDeployer.class);

    public ConfigPullScriptDeployer(JSONObject config) {
        this.fConfigMapScriptResource = config.getString("scriptResource");
    }

    public String toString() {
        return "ConfigPullScriptDeployer";
    }

    @Override
    public void deploy(FlowControlK8sElement.K8sDeployContext ctx) throws FlowControlK8sElement.ElementDeployException {
        try {
            String configMapName = ConfigPullScriptDeployer.tagToConfigPullScriptConfigMap(ctx.getDeployId());
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put(kWorkspaceVal_ConfigPullScriptName, ConfigPullScriptDeployer.loadResource(this.fConfigMapScriptResource));
            V1ConfigMap cm = ((V1ConfigMapBuilder)((V1ConfigMapBuilder)((V1ConfigMapFluent.MetadataNested)((V1ConfigMapBuilder)new V1ConfigMapBuilder().withKind("ConfigMap")).withNewMetadata().withName(configMapName)).endMetadata()).withData(dataMap)).build();
            CoreV1Api api = new CoreV1Api();
            try {
                api.createNamespacedConfigMap(ctx.getNamespace(), cm).execute();
            }
            catch (ApiException e) {
                if (e.getCode() == 409) {
                    api.replaceNamespacedConfigMap(configMapName, ctx.getNamespace(), cm).execute();
                }
                throw e;
            }
            log.info("deployed config map [{}]", (Object)configMapName);
            ctx.getWorkspace().put(kWorkspaceKey_ConfigPullScriptConfigMap, (Object)configMapName);
            ctx.getWorkspace().put(kWorkspaceKey_ConfigPullScriptName, (Object)kWorkspaceVal_ConfigPullScriptName);
        }
        catch (ApiException x) {
            throw new FlowControlK8sElement.ElementDeployException(x);
        }
    }

    @Override
    public boolean isDeployed(FlowControlK8sElement.K8sInstallationContext ctx) throws FlowControlK8sElement.ElementDeployException {
        try {
            String configMapName = ConfigPullScriptDeployer.tagToConfigPullScriptConfigMap(ctx.getDeployId());
            new CoreV1Api().readNamespacedConfigMap(configMapName, ctx.getNamespace()).execute();
            return true;
        }
        catch (ApiException x) {
            if (x.getCode() == 404) {
                return false;
            }
            throw new FlowControlK8sElement.ElementDeployException(x);
        }
    }

    @Override
    public void undeploy(FlowControlK8sElement.K8sInstallationContext ctx) throws FlowControlK8sElement.ElementDeployException {
        String configMapName = ConfigPullScriptDeployer.tagToConfigPullScriptConfigMap(ctx.getDeployId());
        CoreV1Api api = new CoreV1Api();
        try {
            api.deleteNamespacedConfigMap(configMapName, ctx.getNamespace()).execute();
            log.info("Removed {}/{}", (Object)ctx.getNamespace(), (Object)configMapName);
        }
        catch (ApiException x) {
            if (x.getCode() == 404) {
                log.info("Element {} in {} did not exist.", (Object)ctx.getDeployId(), (Object)ctx.getNamespace());
                return;
            }
            throw new FlowControlK8sElement.ElementDeployException(x);
        }
    }

    private static String tagToConfigPullScriptConfigMap(String tag) {
        return tag.trim().toLowerCase() + "-configpull";
    }

    private static String loadResource(String named) throws FlowControlK8sElement.ElementDeployException {
        String string;
        block9: {
            InputStream is = new ResourceLoader().named(named).usingStandardSources(true, ConfigPullScriptDeployer.class).load();
            try {
                if (is == null) {
                    throw new FlowControlK8sElement.ElementDeployException("Couldn't load resource " + named);
                }
                byte[] data = StreamTools.readBytes((InputStream)is);
                string = new String(data, StandardCharsets.UTF_8);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FlowControlK8sElement.ElementDeployException(e);
                }
            }
            is.close();
        }
        return string;
    }
}

