/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.controller.k8s.elements;

import io.continual.flowcontrol.impl.controller.k8s.FlowControlK8sElement;
import io.continual.util.data.json.JsonVisitor;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretBuilder;
import io.kubernetes.client.openapi.models.V1SecretFluent;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretDeployer
implements FlowControlK8sElement {
    public static final String kWorkspaceKey_Secret = "secret";
    public static final String kWorkspaceKey_SecretKeys = "secretKeys";
    private static final Logger log = LoggerFactory.getLogger(SecretDeployer.class);

    public SecretDeployer(JSONObject config) {
    }

    public String toString() {
        return "SecretDeployer";
    }

    @Override
    public void deploy(FlowControlK8sElement.K8sDeployContext ctx) throws FlowControlK8sElement.ElementDeployException {
        try {
            String secretsName = SecretDeployer.tagToSecret(ctx.getDeployId());
            Map secrets = ctx.getDeploymentSpec().getJob().getSecrets(ctx.getEncryptor());
            V1SecretBuilder sb = (V1SecretBuilder)((V1SecretFluent.MetadataNested)((V1SecretBuilder)new V1SecretBuilder().withType("Opaque")).withNewMetadata().withName(secretsName)).endMetadata();
            HashMap<String, byte[]> secretsData = new HashMap<String, byte[]>();
            for (Map.Entry secret : secrets.entrySet()) {
                String val = (String)secret.getValue();
                if (val == null) continue;
                secretsData.put((String)secret.getKey(), ((String)secret.getValue()).getBytes(StandardCharsets.UTF_8));
            }
            if (secretsData.size() > 0) {
                sb.withData(secretsData);
            }
            V1Secret secret = sb.build();
            CoreV1Api api = new CoreV1Api();
            try {
                api.createNamespacedSecret(ctx.getNamespace(), secret).execute();
            }
            catch (ApiException e) {
                if (e.getCode() == 409) {
                    api.replaceNamespacedSecret(secretsName, ctx.getNamespace(), secret).execute();
                }
                throw e;
            }
            log.info("deployed secret [{}]", (Object)secret.getMetadata().getName());
            ctx.getWorkspace().put(kWorkspaceKey_Secret, (Object)secretsName);
            ctx.getWorkspace().put(kWorkspaceKey_SecretKeys, (Object)JsonVisitor.collectionToArray(secrets.keySet()));
        }
        catch (ApiException | GeneralSecurityException x) {
            throw new FlowControlK8sElement.ElementDeployException(x);
        }
    }

    @Override
    public boolean isDeployed(FlowControlK8sElement.K8sInstallationContext ctx) throws FlowControlK8sElement.ElementDeployException {
        try {
            String secretsName = SecretDeployer.tagToSecret(ctx.getDeployId());
            new CoreV1Api().readNamespacedSecret(secretsName, ctx.getNamespace()).execute();
            return true;
        }
        catch (ApiException x) {
            if (x.getCode() == 404) {
                return false;
            }
            throw new FlowControlK8sElement.ElementDeployException(x);
        }
    }

    @Override
    public void undeploy(FlowControlK8sElement.K8sInstallationContext ctx) throws FlowControlK8sElement.ElementDeployException {
        String secretsName = SecretDeployer.tagToSecret(ctx.getDeployId());
        CoreV1Api api = new CoreV1Api();
        try {
            api.deleteNamespacedSecret(secretsName, ctx.getNamespace()).execute();
            log.info("Removed {}/{}", (Object)ctx.getNamespace(), (Object)secretsName);
        }
        catch (ApiException x) {
            if (x.getCode() == 404) {
                log.info("Secret {} in {} did not exist.", (Object)ctx.getDeployId(), (Object)ctx.getNamespace());
                return;
            }
            throw new FlowControlK8sElement.ElementDeployException(x);
        }
    }

    private static String tagToSecret(String tag) {
        return tag.trim().toLowerCase() + "-secret";
    }
}

