/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.controller.k8s.elements;

import io.continual.builder.Builder;
import io.continual.flowcontrol.impl.controller.k8s.FlowControlK8sElement;
import io.continual.flowcontrol.model.FlowControlDeploymentResourceSpec;
import io.continual.flowcontrol.model.FlowControlDeploymentService;
import io.continual.flowcontrol.model.FlowControlRuntimeProcess;
import io.continual.flowcontrol.model.FlowControlRuntimeState;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.impl.noop.NoopMetricsCatalog;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.time.Clock;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.custom.QuantityFormatException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerBuilder;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1EnvVarBuilder;
import io.kubernetes.client.openapi.models.V1EnvVarFluent;
import io.kubernetes.client.openapi.models.V1EnvVarSourceFluent;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimBuilder;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimFluent;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimSpecFluent;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1PodSpecFluent;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluent;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsBuilder;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1StatefulSetBuilder;
import io.kubernetes.client.openapi.models.V1StatefulSetFluent;
import io.kubernetes.client.openapi.models.V1StatefulSetSpecFluent;
import io.kubernetes.client.openapi.models.V1StatefulSetStatus;
import io.kubernetes.client.openapi.models.V1Toleration;
import io.kubernetes.client.openapi.models.V1TolerationBuilder;
import io.kubernetes.client.openapi.models.V1Volume;
import io.kubernetes.client.openapi.models.V1VolumeBuilder;
import io.kubernetes.client.openapi.models.V1VolumeFluent;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import io.kubernetes.client.openapi.models.V1VolumeMountBuilder;
import io.kubernetes.client.util.Yaml;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulSetDeployer
implements FlowControlK8sElement {
    public static final String kSetting_InitContainerImage = "initContainerImage";
    public static final String kDefault_InitContainerImage = "curlimages/curl:7.87.0";
    public static final String kSetting_ConfigMountPath = "configMountPath";
    public static final String kDefault_ConfigMountPath = "/var/flowcontrol/config";
    public static final String kSetting_DeploymentEnvSettings = "applyEnv";
    public static final String kSetting_PersistenceMountPath = "persistenceMountPath";
    public static final String kDefault_PersistenceMountPath = "/var/flowcontrol/persistence";
    public static final String kSetting_PersistenceSize = "persistenceStorageSize";
    public static final String kDefault_PersistenceSize = "8Gi";
    public static final String kSetting_PersistenceStorageClass = "persistenceStorageClass";
    public static final String kDefault_PersistenceStorageClass = "standard";
    public static final String kSetting_LoggingMountPath = "logsMountPath";
    public static final String kDefault_LoggingMountPath = "/var/flowcontrol/logs";
    public static final String kSetting_LoggingSize = "loggingStorageSize";
    public static final String kDefault_LoggingSize = "8Gi";
    public static final String kSetting_LoggingStorageClass = "loggingStorageClass";
    public static final String kDefault_LoggingStorageClass = "standard";
    private final String fInitContainerImage;
    private final String fConfigMountPath;
    private final String fPersistenceMountPath;
    private final Quantity fPersistenceStorageSize;
    private final String fPersistenceStorageClass;
    private final String fLoggingMountPath;
    private final Quantity fLoggingStorageSize;
    private final String fLoggingStorageClass;
    private final Map<String, String> fDeploymentEnvSettings;
    private static final Logger log = LoggerFactory.getLogger(StatefulSetDeployer.class);

    public StatefulSetDeployer(JSONObject config) throws Builder.BuildFailure {
        try {
            this.fInitContainerImage = config.optString(kSetting_InitContainerImage, kDefault_InitContainerImage);
            this.fConfigMountPath = config.optString(kSetting_ConfigMountPath, kDefault_ConfigMountPath);
            this.fDeploymentEnvSettings = JsonVisitor.objectToMap((JSONObject)config.optJSONObject(kSetting_DeploymentEnvSettings));
            this.fPersistenceMountPath = config.optString(kSetting_PersistenceMountPath, kDefault_PersistenceMountPath);
            this.fPersistenceStorageSize = new Quantity(config.optString(kSetting_PersistenceSize, "8Gi"));
            this.fPersistenceStorageClass = config.optString(kSetting_PersistenceStorageClass, "standard");
            this.fLoggingMountPath = config.optString(kSetting_LoggingMountPath, kDefault_LoggingMountPath);
            this.fLoggingStorageSize = new Quantity(config.optString(kSetting_LoggingSize, "8Gi"));
            this.fLoggingStorageClass = config.optString(kSetting_LoggingStorageClass, "standard");
        }
        catch (QuantityFormatException x) {
            throw new Builder.BuildFailure((Throwable)x);
        }
    }

    public String toString() {
        return "StatefulSetDeployer";
    }

    @Override
    public void deploy(FlowControlK8sElement.K8sDeployContext ctx) throws FlowControlK8sElement.ElementDeployException {
        try {
            String containerImage = ctx.getRuntimeImage();
            String ssName = StatefulSetDeployer.tagToStatefulSetName(ctx.getDeployId());
            String secretConfigName = ctx.getWorkspace().getString("secret");
            LinkedList<V1EnvVar> secretRefs = new LinkedList<V1EnvVar>();
            for (Object secretKey : JsonVisitor.arrayToList((JSONArray)ctx.getWorkspace().getJSONArray("secretKeys"))) {
                secretRefs.add(((V1EnvVarBuilder)((V1EnvVarFluent.ValueFromNested)((V1EnvVarSourceFluent.SecretKeyRefNested)((V1EnvVarSourceFluent.SecretKeyRefNested)((V1EnvVarBuilder)new V1EnvVarBuilder().withName((String)secretKey)).withNewValueFrom().withNewSecretKeyRef().withKey((String)secretKey)).withName(secretConfigName)).endSecretKeyRef()).endValueFrom()).build());
            }
            LinkedList<V1LocalObjectReference> ipsList = new LinkedList<V1LocalObjectReference>();
            for (String string : ctx.getImagePullSecrets()) {
                ipsList.add(new V1LocalObjectReference().name(string));
                log.info("Registering image pull secret {}...", (Object)string);
            }
            LinkedList<V1EnvVar> envs = new LinkedList<V1EnvVar>();
            for (Map.Entry<String, String> envVal : ctx.getEnvironment().entrySet()) {
                envs.add(((V1EnvVarBuilder)((V1EnvVarBuilder)new V1EnvVarBuilder().withName(envVal.getKey())).withValue(envVal.getValue())).build());
            }
            for (Map.Entry<String, String> envVal : this.fDeploymentEnvSettings.entrySet()) {
                envs.add(((V1EnvVarBuilder)((V1EnvVarBuilder)new V1EnvVarBuilder().withName(envVal.getKey())).withValue(envVal.getValue())).build());
            }
            envs.add(((V1EnvVarBuilder)((V1EnvVarBuilder)new V1EnvVarBuilder().withName("FC_INSTALLATION_NAME")).withValue(ctx.getInstallationName())).build());
            FlowControlDeploymentResourceSpec flowControlDeploymentResourceSpec = ctx.getDeploymentSpec().getResourceSpecs();
            V1ResourceRequirements resourceReqs = this.buildResourceReqs(flowControlDeploymentResourceSpec);
            LinkedList<V1Toleration> tols = new LinkedList<V1Toleration>();
            for (FlowControlDeploymentResourceSpec.Toleration t : flowControlDeploymentResourceSpec.tolerations()) {
                tols.add(((V1TolerationBuilder)((V1TolerationBuilder)((V1TolerationBuilder)((V1TolerationBuilder)((V1TolerationBuilder)new V1TolerationBuilder().withEffect(t.effect())).withKey(t.key())).withOperator(t.operator())).withTolerationSeconds(t.seconds())).withValue(t.value())).build());
            }
            V1StatefulSet ss = ((V1StatefulSetBuilder)((V1StatefulSetFluent.SpecNested)((V1StatefulSetFluent.SpecNested)((V1StatefulSetSpecFluent.TemplateNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodSpecFluent.SecurityContextNested)((V1PodSpecFluent.SecurityContextNested)((V1PodSpecFluent.SecurityContextNested)((V1PodTemplateSpecFluent.SpecNested)((V1PodTemplateSpecFluent.SpecNested)((V1StatefulSetSpecFluent.TemplateNested)((V1PodTemplateSpecFluent.MetadataNested)((V1StatefulSetFluent.SpecNested)((V1StatefulSetSpecFluent.SelectorNested)((V1StatefulSetFluent.SpecNested)((V1StatefulSetFluent.SpecNested)((V1StatefulSetBuilder)((V1StatefulSetFluent.MetadataNested)((V1StatefulSetFluent.MetadataNested)((V1StatefulSetFluent.MetadataNested)new V1StatefulSetBuilder().withNewMetadata().withName(ssName)).addToLabels("app", ctx.getDeployId())).addToLabels("flowcontroljob", ctx.getDeployId())).endMetadata()).withNewSpec().withServiceName(ctx.getDeployId())).withReplicas(Integer.valueOf(ctx.getDeploymentSpec().getInstanceCount()))).withNewSelector().addToMatchLabels("app", ctx.getDeployId())).endSelector()).withNewTemplate().withNewMetadata().addToLabels("app", ctx.getDeployId())).endMetadata()).withNewSpec().withImagePullSecrets(ipsList)).withTolerations(tols)).withNewSecurityContext().withRunAsUser(Long.valueOf(1000L))).withRunAsGroup(Long.valueOf(3000L))).withFsGroup(Long.valueOf(2000L))).endSecurityContext()).withVolumes(new V1Volume[]{((V1VolumeBuilder)((V1VolumeBuilder)new V1VolumeBuilder().withName("configdisk")).withNewEmptyDir().endEmptyDir()).build(), ((V1VolumeBuilder)((V1VolumeFluent.ConfigMapNested)((V1VolumeFluent.ConfigMapNested)((V1VolumeBuilder)new V1VolumeBuilder().withName("sysprep")).withNewConfigMap().withName(ctx.getWorkspace().getString("configPullConfigMap"))).withDefaultMode(Integer.valueOf(493))).endConfigMap()).build()})).withInitContainers(new V1Container[]{((V1ContainerBuilder)((V1ContainerBuilder)((V1ContainerBuilder)((V1ContainerBuilder)((V1ContainerBuilder)((V1ContainerBuilder)new V1ContainerBuilder().withName("initializer")).withImage(this.fInitContainerImage)).withVolumeMounts(new V1VolumeMount[]{((V1VolumeMountBuilder)((V1VolumeMountBuilder)new V1VolumeMountBuilder().withName("configdisk")).withMountPath(this.fConfigMountPath)).build(), ((V1VolumeMountBuilder)((V1VolumeMountBuilder)new V1VolumeMountBuilder().withName("sysprep")).withMountPath("/usr/local/bin")).build()})).addAllToEnv(secretRefs)).addAllToEnv(envs)).withCommand(new String[]{"/usr/local/bin/sysprep"})).build()})).withContainers(new V1Container[]{((V1ContainerBuilder)((V1ContainerBuilder)((V1ContainerBuilder)((V1ContainerBuilder)((V1ContainerBuilder)((V1ContainerBuilder)((V1ContainerBuilder)new V1ContainerBuilder().withName("processor")).withImage(containerImage)).withImagePullPolicy(ctx.getImagePullPolicy().toString())).withVolumeMounts(new V1VolumeMount[]{((V1VolumeMountBuilder)((V1VolumeMountBuilder)new V1VolumeMountBuilder().withName("configdisk")).withMountPath(this.fConfigMountPath)).build(), ((V1VolumeMountBuilder)((V1VolumeMountBuilder)new V1VolumeMountBuilder().withName("persistence")).withMountPath(this.fPersistenceMountPath)).build(), ((V1VolumeMountBuilder)((V1VolumeMountBuilder)new V1VolumeMountBuilder().withName("logging")).withMountPath(this.fLoggingMountPath)).build()})).withResources(resourceReqs)).addAllToEnv(secretRefs)).addAllToEnv(envs)).build()})).endSpec()).endTemplate()).withVolumeClaimTemplates(new V1PersistentVolumeClaim[]{((V1PersistentVolumeClaimBuilder)((V1PersistentVolumeClaimFluent.SpecNested)((V1PersistentVolumeClaimFluent.SpecNested)((V1PersistentVolumeClaimSpecFluent.ResourcesNested)((V1PersistentVolumeClaimFluent.SpecNested)((V1PersistentVolumeClaimBuilder)((V1PersistentVolumeClaimFluent.MetadataNested)new V1PersistentVolumeClaimBuilder().withNewMetadata().withName("persistence")).endMetadata()).withNewSpec().withAccessModes(new String[]{"ReadWriteOnce"})).withNewResources().addToRequests("storage", this.fPersistenceStorageSize)).endResources()).withStorageClassName(this.fPersistenceStorageClass)).endSpec()).build(), ((V1PersistentVolumeClaimBuilder)((V1PersistentVolumeClaimFluent.SpecNested)((V1PersistentVolumeClaimFluent.SpecNested)((V1PersistentVolumeClaimSpecFluent.ResourcesNested)((V1PersistentVolumeClaimFluent.SpecNested)((V1PersistentVolumeClaimBuilder)((V1PersistentVolumeClaimFluent.MetadataNested)new V1PersistentVolumeClaimBuilder().withNewMetadata().withName("logging")).endMetadata()).withNewSpec().withAccessModes(new String[]{"ReadWriteOnce"})).withNewResources().addToRequests("storage", this.fLoggingStorageSize)).endResources()).withStorageClassName(this.fLoggingStorageClass)).endSpec()).build()})).endSpec()).build();
            String yamlRepresentation = Yaml.dump((Object)ss);
            try (FileOutputStream fos = new FileOutputStream(new File("/tmp/fc.yaml"));){
                fos.write(yamlRepresentation.getBytes());
            }
            catch (IOException x) {
                log.warn("Couldn't dump YAML.", (Throwable)x);
            }
            AppsV1Api api = new AppsV1Api();
            try {
                api.createNamespacedStatefulSet(ctx.getNamespace(), ss).execute();
            }
            catch (ApiException e) {
                if (e.getCode() == 409) {
                    api.replaceNamespacedStatefulSet(ssName, ctx.getNamespace(), ss).execute();
                }
                throw e;
            }
            log.info("deployed stateful set [{}]", (Object)ssName);
        }
        catch (ApiException x) {
            throw new FlowControlK8sElement.ElementDeployException(x);
        }
    }

    @Override
    public boolean isDeployed(FlowControlK8sElement.K8sInstallationContext ctx) throws FlowControlK8sElement.ElementDeployException {
        try {
            String ssName = StatefulSetDeployer.tagToStatefulSetName(ctx.getDeployId());
            new AppsV1Api().readNamespacedStatefulSet(ssName, ctx.getNamespace()).execute();
            return true;
        }
        catch (ApiException x) {
            if (x.getCode() == 404) {
                return false;
            }
            throw new FlowControlK8sElement.ElementDeployException(x);
        }
    }

    @Override
    public boolean isRuntimeProvider() {
        return true;
    }

    @Override
    public FlowControlRuntimeState getRuntimeState(final FlowControlK8sElement.K8sInstallationContext ctx) throws FlowControlK8sElement.ElementDeployException {
        if (!this.isDeployed(ctx)) {
            return FlowControlRuntimeState.notRunning();
        }
        try {
            String ssName = StatefulSetDeployer.tagToStatefulSetName(ctx.getDeployId());
            V1StatefulSet ss = new AppsV1Api().readNamespacedStatefulSet(ssName, ctx.getNamespace()).execute();
            V1StatefulSetStatus sss = ss.getStatus();
            final int availablePods = sss.getAvailableReplicas();
            final int desiredPods = sss.getReplicas();
            Map matchLabels = ss.getSpec().getSelector().getMatchLabels();
            String labelSelector = matchLabels.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
            V1PodList podList = new CoreV1Api().listNamespacedPod(ctx.getNamespace()).labelSelector(labelSelector).execute();
            final HashMap pods = new HashMap();
            podList.getItems().stream().forEach(pod -> pods.put(pod.getMetadata().getName(), pod));
            return new FlowControlRuntimeState(){
                final /* synthetic */ StatefulSetDeployer this$0;
                {
                    this.this$0 = this$0;
                }

                public FlowControlRuntimeState.DeploymentStatus getStatus() {
                    if (availablePods < desiredPods) {
                        return FlowControlRuntimeState.DeploymentStatus.PENDING;
                    }
                    if (availablePods >= desiredPods) {
                        return FlowControlRuntimeState.DeploymentStatus.RUNNING;
                    }
                    return FlowControlRuntimeState.DeploymentStatus.UNKNOWN;
                }

                public Set<String> getProcesses() {
                    return Collections.unmodifiableSet(pods.keySet());
                }

                public FlowControlRuntimeProcess getProcess(final String processId) {
                    return new FlowControlRuntimeProcess(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public String getProcessId() {
                            return processId;
                        }

                        public List<String> getLog(String sinceRfc3339Time) throws FlowControlDeploymentService.ServiceException, FlowControlDeploymentService.RequestException {
                            try {
                                long sinceSeconds = Integer.MAX_VALUE;
                                if (sinceRfc3339Time != null) {
                                    try {
                                        long requestedTimeSec = Instant.parse(sinceRfc3339Time).getEpochSecond();
                                        sinceSeconds = Clock.now() / 1000L - requestedTimeSec;
                                    }
                                    catch (DateTimeParseException e) {
                                        throw new FlowControlDeploymentService.RequestException("Couldn't parse RFC3339 date string [" + sinceRfc3339Time + "]", (Throwable)e);
                                    }
                                }
                                String logResponse = new CoreV1Api().readNamespacedPodLog(processId, this.this$1.ctx.getNamespace()).sinceSeconds(Integer.valueOf(sinceSeconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)sinceSeconds)).execute();
                                LinkedList<String> result = new LinkedList<String>();
                                result.add(logResponse);
                                return result;
                            }
                            catch (ApiException x) {
                                throw new FlowControlDeploymentService.ServiceException((Throwable)x);
                            }
                        }

                        public MetricsCatalog getMetrics() {
                            return new NoopMetricsCatalog();
                        }
                    };
                }
            };
        }
        catch (ApiException x) {
            throw new FlowControlK8sElement.ElementDeployException(x);
        }
    }

    @Override
    public void undeploy(FlowControlK8sElement.K8sInstallationContext ctx) throws FlowControlK8sElement.ElementDeployException {
        String ssName = StatefulSetDeployer.tagToStatefulSetName(ctx.getDeployId());
        AppsV1Api api = new AppsV1Api();
        try {
            api.deleteNamespacedStatefulSet(ssName, ctx.getNamespace()).execute();
            log.info("Removed {}/{}", (Object)ctx.getNamespace(), (Object)ssName);
        }
        catch (ApiException x) {
            if (x.getCode() == 404) {
                log.info("Element {} in {} did not exist.", (Object)ssName, (Object)ctx.getNamespace());
                return;
            }
            throw new FlowControlK8sElement.ElementDeployException(x);
        }
    }

    private static String tagToStatefulSetName(String deployId) {
        return "s-" + deployId.trim().toLowerCase();
    }

    private V1ResourceRequirements buildResourceReqs(FlowControlDeploymentResourceSpec rs) {
        String cpuReq;
        V1ResourceRequirementsBuilder resourceReqsBuilder = new V1ResourceRequirementsBuilder();
        HashMap<String, Quantity> map = new HashMap<String, Quantity>();
        String mem = rs.memLimit();
        if (mem != null) {
            map.put("memory", new Quantity(mem));
        }
        if ((cpuReq = rs.cpuRequest()) != null) {
            map.put("cpu", new Quantity(cpuReq));
        }
        if (map.size() > 0) {
            resourceReqsBuilder.withRequests(map);
        }
        map.clear();
        String cpuLimit = rs.cpuLimit();
        if (mem != null) {
            map.put("memory", new Quantity(mem));
        }
        if (cpuLimit != null) {
            map.put("cpu", new Quantity(cpuLimit));
        }
        if (map.size() > 0) {
            resourceReqsBuilder.withLimits(map);
        }
        return resourceReqsBuilder.build();
    }
}

