/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.controller.k8s.impl;

import io.continual.builder.Builder;
import io.continual.flowcontrol.impl.controller.k8s.impl.ContainerImageMapper;
import io.continual.flowcontrol.model.FlowControlDeploymentService;
import io.continual.flowcontrol.model.FlowControlJob;
import io.continual.services.ServiceContainer;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.json.JsonVisitor;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JsonDataImageMapper
implements ContainerImageMapper {
    public JsonDataImageMapper(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
    }

    @Override
    public String getImageName(FlowControlJob.FlowControlRuntimeSpec rs) throws FlowControlDeploymentService.RequestException, FlowControlDeploymentService.ServiceException {
        String request = rs.getName() + ":" + rs.getVersion();
        for (Rule rule : this.getMap()) {
            if (!request.matches(rule.fRegex)) continue;
            return rule.fContainer;
        }
        throw new FlowControlDeploymentService.RequestException("Couldn't map runtime specification " + request + " to a container image.");
    }

    protected abstract List<Rule> getMap() throws FlowControlDeploymentService.ServiceException;

    protected List<Rule> readMapData(JSONObject data) throws FlowControlDeploymentService.ServiceException {
        final LinkedList<Rule> map = new LinkedList<Rule>();
        try {
            JsonVisitor.forEachElement((JSONArray)data.optJSONArray("rules"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, FlowControlDeploymentService.ServiceException>(){
                final /* synthetic */ JsonDataImageMapper this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean visit(JSONObject ruleData) throws JSONException, FlowControlDeploymentService.ServiceException {
                    String match = ruleData.getString("match");
                    String image = ExpressionEvaluator.getStandardEvaluator().evaluateText(ruleData.getString("image"));
                    map.add(this.this$0.new Rule(match, image));
                    return true;
                }
            });
        }
        catch (JSONException e) {
            throw new FlowControlDeploymentService.ServiceException((Throwable)e);
        }
        return map;
    }

    protected class Rule {
        public final String fRegex;
        public final String fContainer;

        public Rule(String regex, String container) {
            this.fRegex = regex;
            this.fContainer = container;
        }
    }
}

