/*
 * Decompiled with CFR 0.152.
 */
package io.continual.flowcontrol.impl.controller.k8s.impl;

import io.continual.builder.Builder;
import io.continual.flowcontrol.impl.controller.k8s.impl.ContainerImageMapper;
import io.continual.flowcontrol.impl.controller.k8s.impl.JsonDataImageMapper;
import io.continual.flowcontrol.model.FlowControlDeploymentService;
import io.continual.services.ServiceContainer;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.data.BasicModelObject;
import io.continual.services.model.core.data.JsonModelObject;
import io.continual.services.model.core.data.ModelObject;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import io.continual.util.time.Clock;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;

public class ModelBackedImageMapper
extends JsonDataImageMapper
implements ContainerImageMapper {
    public static final String kSetting_ReadIntervalMs = "readIntervalMs";
    public static final long kDefault_ReadIntervalMs = 300000L;
    private final Model fModel;
    private final long fReadIntervalMs;
    private LinkedList<JsonDataImageMapper.Rule> fMap;
    private long fLastReadMs;
    private static final Path skMapPath = Path.getRootPath().makeChildItem(Name.fromString((String)"imageMap"));

    public ModelBackedImageMapper(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        super(sc, config);
        this.fModel = (Model)sc.getReqd("db", Model.class);
        this.fReadIntervalMs = sc.getExprEval().evaluateTextToLong(config.opt(kSetting_ReadIntervalMs), 300000L);
        this.fLastReadMs = 0L;
        this.fMap = new LinkedList();
    }

    @Override
    protected List<JsonDataImageMapper.Rule> getMap() throws FlowControlDeploymentService.ServiceException {
        long nowMs = Clock.now();
        if (nowMs > this.fLastReadMs + this.fReadIntervalMs) {
            this.readModelMap();
            this.fLastReadMs = nowMs;
        }
        return this.fMap;
    }

    private void readModelMap() throws FlowControlDeploymentService.ServiceException {
        try {
            ModelRequestContext mrc = this.fModel.getRequestContextBuilder().build();
            BasicModelObject mo = this.fModel.load(mrc, skMapPath);
            JSONObject data = JsonModelObject.modelObjectToJson((ModelObject)mo.getData());
            this.fMap.clear();
            this.fMap.addAll(super.readMapData(data));
        }
        catch (Builder.BuildFailure | ModelRequestException | ModelServiceException e) {
            throw new FlowControlDeploymentService.ServiceException(e);
        }
    }
}

